/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.io.stream.FastByteArrayOutputStream;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.xyz.ColorKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.UrlKit;
import org.miaixz.bus.extra.image.ImageRemoval;
import org.miaixz.bus.extra.image.ImageText;
import org.miaixz.bus.extra.image.ImageWriter;
import org.miaixz.bus.extra.image.Images;
import org.miaixz.bus.extra.image.RenderingHintsBuilder;

public class ImageKit {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(File srcImageFile, File destImageFile, float scale) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImageFile);
            ImageKit.scale((Image)image, destImageFile, scale);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(InputStream srcStream, OutputStream targetStream, float scale) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.scale((Image)image, targetStream, scale);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(ImageInputStream srcStream, ImageOutputStream targetStream, float scale) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.scale((Image)image, targetStream, scale);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void scale(Image srcImg, File destFile, float scale) throws InternalException {
        Images.from(srcImg).setTargetImageType(FileName.extName((File)destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale) throws InternalException {
        ImageKit.scale(srcImg, ImageKit.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws InternalException {
        ImageKit.writeJpg(ImageKit.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(Image srcImg, float scale) {
        return Images.from(srcImg).scale(scale).getImg();
    }

    public static Image scale(Image srcImg, int width, int height) {
        return Images.from(srcImg).scale(width, height).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(File srcImageFile, File targetImageFile, int width, int height, Color fixedColor) throws InternalException {
        Images images = null;
        try {
            images = Images.from(srcImageFile);
            images.setTargetImageType(FileName.extName((File)targetImageFile)).scale(width, height, fixedColor).write(targetImageFile);
        }
        finally {
            IoKit.flush((Flushable)images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(InputStream srcStream, OutputStream targetStream, int width, int height, Color fixedColor) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.scale(image, ImageKit.getImageOutputStream(targetStream), width, height, fixedColor);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scale(ImageInputStream srcStream, ImageOutputStream targetStream, int width, int height, Color fixedColor) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.scale(image, targetStream, width, height, fixedColor);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void scale(Image srcImage, ImageOutputStream targetImageStream, int width, int height, Color fixedColor) throws InternalException {
        ImageKit.writeJpg(ImageKit.scale(srcImage, width, height, fixedColor), targetImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return Images.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(File srcImgFile, File targetImgFile, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImgFile);
            ImageKit.cut((Image)image, targetImgFile, rectangle);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(InputStream srcStream, OutputStream targetStream, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.cut((Image)image, targetStream, rectangle);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(ImageInputStream srcStream, ImageOutputStream targetStream, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.cut((Image)image, targetStream, rectangle);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws InternalException {
        ImageKit.write(ImageKit.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws InternalException {
        ImageKit.cut(srcImage, ImageKit.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream targetImageStream, Rectangle rectangle) throws InternalException {
        ImageKit.writeJpg(ImageKit.cut(srcImage, rectangle), targetImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return Images.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImageKit.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return Images.from(srcImage).cut(x, y, radius).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void slice(File srcImageFile, File descDir, int targetWidth, int targetHeight) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImageFile);
            ImageKit.slice(image, descDir, targetWidth, targetHeight);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void slice(Image srcImage, File descDir, int targetWidth, int targetHeight) {
        if (targetWidth <= 0) {
            targetWidth = 200;
        }
        if (targetHeight <= 0) {
            targetHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < targetWidth) {
            targetWidth = srcWidth;
        }
        if (srcHeight < targetHeight) {
            targetHeight = srcHeight;
        }
        int cols = srcWidth % targetWidth == 0 ? srcWidth / targetWidth : (int)Math.floor((double)srcWidth / (double)targetWidth) + 1;
        int rows = srcHeight % targetHeight == 0 ? srcHeight / targetHeight : (int)Math.floor((double)srcHeight / (double)targetHeight) + 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImageKit.cut(srcImage, new Rectangle(j * targetWidth, i * targetHeight, targetWidth, targetHeight));
                ImageKit.write(tag, FileKit.file((File)descDir, (String)("_r" + i + "_c" + j + ".jpg")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sliceByRowsAndCols(File srcImageFile, File targetDir, String formatName, int rows, int cols) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImageFile);
            ImageKit.sliceByRowsAndCols(image, targetDir, formatName, rows, cols);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, String formatName, int rows, int cols) {
        if (!destDir.exists()) {
            FileKit.mkdir((File)destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination must be a Directory !");
        }
        if (rows <= 0 || rows > 20) {
            rows = 2;
        }
        if (cols <= 0 || cols > 20) {
            cols = 2;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        int targetWidth = MathKit.partValue((int)srcWidth, (int)cols);
        int targetHeight = MathKit.partValue((int)srcHeight, (int)rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImageKit.cut(srcImage, new Rectangle(j * targetWidth, i * targetHeight, targetWidth, targetHeight));
                ImageKit.write(tag, new File(destDir, "_r" + i + "_c" + j + "." + formatName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File targetImageFile) {
        Assert.notNull((Object)srcImageFile);
        Assert.notNull((Object)targetImageFile);
        Assert.isFalse((boolean)srcImageFile.equals(targetImageFile), (String)"Src file is equals to dest file!", (Object[])new Object[0]);
        String srcExtName = FileName.extName((File)srcImageFile);
        String destExtName = FileName.extName((File)targetImageFile);
        if (StringKit.equalsIgnoreCase((CharSequence)srcExtName, (CharSequence)destExtName)) {
            FileKit.copy((File)srcImageFile, (File)targetImageFile, (boolean)true);
        }
        Images images = null;
        try {
            images = Images.from(srcImageFile);
            images.write(targetImageFile);
        }
        finally {
            IoKit.flush((Flushable)images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(InputStream srcStream, String formatName, OutputStream targetStream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.write((Image)image, formatName, ImageKit.getImageOutputStream(targetStream));
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream targetImageStream) {
        Images.from(srcImage).setTargetImageType(formatName).write(targetImageStream);
    }

    public static void gray(File srcImageFile, File targetImageFile) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImageFile);
            ImageKit.gray((Image)image, targetImageFile);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void gray(InputStream srcStream, OutputStream targetStream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.gray((Image)image, targetStream);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream targetStream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.gray((Image)image, targetStream);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void gray(Image srcImage, File outFile) {
        ImageKit.write(ImageKit.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImageKit.gray(srcImage, ImageKit.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream targetImageStream) throws InternalException {
        ImageKit.writeJpg(ImageKit.gray(srcImage), targetImageStream);
    }

    public static Image gray(Image srcImage) {
        return Images.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File targetImageFile) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImageFile);
            ImageKit.binary(image, targetImageFile);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void binary(InputStream srcStream, OutputStream targetStream, String imageType) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.binary((Image)image, ImageKit.getImageOutputStream(targetStream), imageType);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void binary(ImageInputStream srcStream, ImageOutputStream targetStream, String imageType) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.binary((Image)image, targetStream, imageType);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void binary(Image srcImage, File outFile) {
        ImageKit.write(ImageKit.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImageKit.binary(srcImage, ImageKit.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream targetImageStream, String imageType) throws InternalException {
        ImageKit.write(ImageKit.binary(srcImage), imageType, targetImageStream);
    }

    public static Image binary(Image srcImage) {
        return Images.from(srcImage).binary().getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressText(File imageFile, File targetFile, ImageText pressText) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(imageFile);
            ImageKit.pressText((Image)image, targetFile, pressText);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressText(InputStream srcStream, OutputStream targetStream, ImageText pressText) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.pressText((Image)image, ImageKit.getImageOutputStream(targetStream), pressText);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void pressText(Image srcImage, File targetFile, ImageText pressText) throws InternalException {
        ImageKit.write(ImageKit.pressText(srcImage, pressText), targetFile);
    }

    public static void pressText(Image srcImage, OutputStream to, ImageText pressText) throws InternalException {
        ImageKit.pressText(srcImage, ImageKit.getImageOutputStream(to), pressText);
    }

    public static void pressText(Image srcImage, ImageOutputStream targetImageStream, ImageText pressText) throws InternalException {
        ImageKit.writeJpg(ImageKit.pressText(srcImage, pressText), targetImageStream);
    }

    public static Image pressText(Image srcImage, ImageText pressText) {
        return Images.from(srcImage).pressText(pressText).getImg();
    }

    public static Image pressTextFull(Image srcImage, String pressText, Color color, Font font, int lineHeight, int degree, float alpha) {
        return Images.from(srcImage).pressTextFull(pressText, color, font, lineHeight, degree, alpha).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImage(File srcImageFile, File targetImageFile, Image pressImg, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcImageFile);
            ImageKit.pressImage((Image)image, targetImageFile, pressImg, x, y, alpha);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImage(InputStream srcStream, OutputStream targetStream, Image pressImg, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.pressImage((Image)image, ImageKit.getImageOutputStream(targetStream), pressImg, x, y, alpha);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws InternalException {
        ImageKit.write(ImageKit.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws InternalException {
        ImageKit.pressImage(srcImage, ImageKit.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream targetImageStream, Image pressImg, int x, int y, float alpha) throws InternalException {
        ImageKit.writeJpg(ImageKit.pressImage(srcImage, pressImg, x, y, alpha), targetImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return Images.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImg, Rectangle rectangle, float alpha) {
        return Images.from(srcImage).pressImage(pressImg, rectangle, alpha).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImageFull(File imageFile, File targetFile, File pressImageFile, int lineHeight, int degree, float alpha) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.read(imageFile);
            ImageKit.write(ImageKit.pressImageFull(image, ImageKit.read(pressImageFile), lineHeight, degree, alpha), targetFile);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pressImageFull(InputStream srcStream, OutputStream targetStream, InputStream pressStream, int lineHeight, int degree, float alpha) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.writeJpg(ImageKit.pressImageFull(image, ImageKit.read(pressStream), lineHeight, degree, alpha), targetStream);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static Image pressImageFull(Image srcImage, Image pressImage, int lineHeight, int degree, float alpha) {
        return Images.from(srcImage).pressImageFull(pressImage, lineHeight, degree, alpha).getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotate(File imageFile, int degree, File outFile) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.read(imageFile);
            ImageKit.rotate((Image)image, degree, outFile);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void rotate(Image image, int degree, File outFile) throws InternalException {
        ImageKit.write(ImageKit.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws InternalException {
        ImageKit.writeJpg(ImageKit.rotate(image, degree), ImageKit.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws InternalException {
        ImageKit.writeJpg(ImageKit.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return Images.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.read(imageFile);
            ImageKit.flip((Image)image, outFile);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void flip(Image image, File outFile) throws InternalException {
        ImageKit.write(ImageKit.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws InternalException {
        ImageKit.flip(image, ImageKit.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws InternalException {
        ImageKit.writeJpg(ImageKit.flip(image), out);
    }

    public static Image flip(Image image) {
        return Images.from(image).flip().getImg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File imageFile, File outFile, float quality) throws InternalException {
        Images images = null;
        try {
            images = Images.from(imageFile);
            images.setQuality(quality).write(outFile);
        }
        finally {
            IoKit.flush((Flushable)images);
        }
    }

    public static RenderedImage castToRenderedImage(Image img, String imageType) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImageKit.toBufferedImage(img, imageType);
    }

    public static BufferedImage castToBufferedImage(Image img, String imageType) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImageKit.toBufferedImage(img, imageType);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        return ImageKit.toBufferedImage(image, imageType, null);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType, Color backgroundColor) {
        int type = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return ImageKit.toBufferedImage(image, type, backgroundColor);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        return ImageKit.toBufferedImage(image, imageType, null);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType, Color backgroundColor) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImageKit.copyImage(image, imageType, backgroundColor);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImageKit.copyImage(image, imageType, backgroundColor);
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        return ImageKit.copyImage(img, imageType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        img = new ImageIcon(img).getImage();
        BufferedImage bImage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = ImageKit.createGraphics(bImage, backgroundColor);
        try {
            ImageKit.drawImg((Graphics)bGr, img, new Point());
        }
        finally {
            bGr.dispose();
        }
        return bImage;
    }

    public static BufferedImage toImage(String base64) throws InternalException {
        return ImageKit.toImage(Base64.decode((CharSequence)base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws InternalException {
        return ImageKit.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) {
        return IoKit.toStream((byte[])ImageKit.toBytes(image, imageType));
    }

    public static String toBase64DataUri(Image image, String imageType) {
        return UrlKit.getDataUri((String)("image/" + imageType), (String)"base64", (String)ImageKit.toBase64(image, imageType));
    }

    public static String toBase64(Image image, String imageType) {
        return Base64.encode((byte[])ImageKit.toBytes(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        ImageKit.write(image, imageType, (OutputStream)out);
        return out.toByteArrayZeroCopyIfPossible();
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTransparentImage(String text, Font font, Color fontColor, ImageOutputStream out) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.createImage(text, font, null, fontColor, 2);
            ImageKit.writePng((Image)image, out);
        }
        catch (Throwable throwable) {
            ImageKit.flush(image);
            throw throwable;
        }
        ImageKit.flush(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createImage(String text, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws InternalException {
        BufferedImage image = null;
        try {
            image = ImageKit.createImage(text, font, backgroundColor, fontColor, 2);
            ImageKit.writePng((Image)image, out);
        }
        catch (Throwable throwable) {
            ImageKit.flush(image);
            throw throwable;
        }
        ImageKit.flush(image);
    }

    public static BufferedImage createImage(String text, Font font, Color backgroundColor, Color fontColor, int imageType) throws InternalException {
        Rectangle2D r = ImageKit.getRectangle(text, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g = ImageKit.createGraphics(image, backgroundColor);
        ImageKit.drawString((Graphics)g, text, font, fontColor, new Point(0, font.getSize()));
        g.dispose();
        return image;
    }

    public static void writeJpg(Image image, ImageOutputStream targetImageStream) throws InternalException {
        ImageKit.write(image, IMAGE_TYPE_JPG, targetImageStream);
    }

    public static void writePng(Image image, ImageOutputStream targetImageStream) throws InternalException {
        ImageKit.write(image, IMAGE_TYPE_PNG, targetImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws InternalException {
        ImageKit.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(Image image, OutputStream out) throws InternalException {
        ImageKit.write(image, IMAGE_TYPE_PNG, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ImageInputStream srcStream, String formatName, ImageOutputStream targetStream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(srcStream);
            ImageKit.write((Image)image, formatName, targetStream);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static void write(Image image, String imageType, OutputStream out) throws InternalException {
        ImageKit.write(image, imageType, ImageKit.getImageOutputStream(out));
    }

    public static void write(Image image, File targetFile) throws InternalException {
        ImageWriter.of(image, FileName.extName((File)targetFile)).write(targetFile);
    }

    public static void write(Image image, String imageType, ImageOutputStream targetImageStream) throws InternalException {
        ImageKit.write(image, imageType, targetImageStream, 1.0f);
    }

    public static void write(Image image, String imageType, ImageOutputStream out, float quality, Color backgroundColor) throws InternalException {
        BufferedImage bufferedImage = ImageKit.toBufferedImage(image, imageType, backgroundColor);
        ImageKit.write(bufferedImage, imageType, out, quality);
    }

    public static void write(Image image, String imageType, ImageOutputStream output, float quality) {
        ImageWriter.of(image, imageType).setQuality(quality).write(output);
    }

    public static javax.imageio.ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type;
        Iterator<javax.imageio.ImageWriter> iter;
        if (null == formatName) {
            formatName = IMAGE_TYPE_JPG;
        }
        return (iter = ImageIO.getImageWriters(type = ImageTypeSpecifier.createFromRenderedImage(ImageKit.toBufferedImage(img, formatName)), formatName)).hasNext() ? iter.next() : null;
    }

    public static javax.imageio.ImageWriter getWriter(String formatName) {
        if (null == formatName) {
            formatName = IMAGE_TYPE_JPG;
        }
        javax.imageio.ImageWriter writer = null;
        Iterator<javax.imageio.ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImageKit.read(FileKit.file((String)imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static BufferedImage read(Resource resource) {
        return ImageKit.read(resource.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(URL imageUrl) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of [" + String.valueOf(imageUrl) + "] is not supported!");
        }
        return result;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static Pair<Integer, Integer> getWidthAndHeight(InputStream imageStream, String type) {
        return ImageKit.getWidthAndHeight(ImageKit.getImageInputStream(imageStream), type);
    }

    public static Pair<Integer, Integer> getWidthAndHeight(ImageInputStream imageStream, String type) {
        ImageReader reader = ImageKit.getReader(type);
        if (null != reader) {
            reader.setInput(imageStream, true);
            try {
                return Pair.of((Object)reader.getWidth(0), (Object)reader.getHeight(0));
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return null;
    }

    public static Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws InternalException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws InternalException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws InternalException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(in);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static Point getPointBaseCentre(Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle.x + Math.abs(backgroundWidth - rectangle.width) / 2, rectangle.y + Math.abs(backgroundHeight - rectangle.height) / 2);
    }

    public static void backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        ImageRemoval.backgroundRemoval(inputPath, outputPath, tolerance);
    }

    public static void backgroundRemoval(File input, File output, int tolerance) {
        ImageRemoval.backgroundRemoval(input, output, tolerance);
    }

    public static void backgroundRemoval(File input, File output, Color override, int tolerance) {
        ImageRemoval.backgroundRemoval(input, output, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        return ImageRemoval.backgroundRemoval(bufferedImage, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        return ImageRemoval.backgroundRemoval(outputStream, override, tolerance);
    }

    public static BufferedImage colorConvert(ColorSpace colorSpace, BufferedImage image) {
        return ImageKit.filter(new ColorConvertOp(colorSpace, null), image);
    }

    public static BufferedImage transform(AffineTransform xform, BufferedImage image) {
        return ImageKit.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(ImageFilter filter, Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
    }

    public static void flush(Image image) {
        if (null != image) {
            image.flush();
        }
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        if (null != color) {
            g.setColor(color);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g;
    }

    public static int getCenterY(Graphics g, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static Graphics drawStringColourful(Graphics g, String text, Font font, int width, int height) {
        return ImageKit.drawString(g, text, font, null, width, height);
    }

    public static Graphics drawString(Graphics g, String text, Font font, Color color, int width, int height) {
        ImageKit.enableAntialias(g);
        g.setFont(font);
        int midY = ImageKit.getCenterY(g, height);
        if (null != color) {
            g.setColor(color);
        }
        int len = text.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                g.setColor(ColorKit.randomColor());
            }
            g.drawString(String.valueOf(text.charAt(i)), i * charWidth, midY);
        }
        return g;
    }

    public static Graphics drawString(Graphics g, String text, Font font, Color color, Rectangle rectangle) {
        Dimension dimension;
        int backgroundWidth = rectangle.width;
        int backgroundHeight = rectangle.height;
        try {
            dimension = ImageKit.getDimension(g.getFontMetrics(font), text);
        }
        catch (Exception e) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImageKit.getPointBaseCentre(rectangle, backgroundWidth, backgroundHeight);
        return ImageKit.drawString(g, text, font, color, point);
    }

    public static Graphics drawString(Graphics g, String text, Font font, Color color, Point point) {
        ImageKit.enableAntialias(g);
        g.setFont(font);
        g.setColor((Color)ObjectKit.defaultIfNull((Object)color, (Object)Color.BLACK));
        g.drawString(text, point.x, point.y);
        return g;
    }

    public static Graphics drawImg(Graphics g, Image img, Point point) {
        g.drawImage(img, point.x, point.y, null);
        return g;
    }

    public static Graphics drawImg(Graphics g, Image img, Rectangle rectangle) {
        g.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        return g;
    }

    public static Graphics2D setAlpha(Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        return g;
    }

    private static void enableAntialias(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHints(RenderingHintsBuilder.of().setAntialiasing(RenderingHintsBuilder.Antialias.ON).setTextAntialias(RenderingHintsBuilder.TextAntialias.ON).build());
        }
    }

    public static Font createFont() {
        return new Font(null);
    }

    public static Font createSansSerifFont(int size) {
        return ImageKit.createFont("SansSerif", size);
    }

    public static Font createFont(String name, int size) {
        return new Font(name, 0, size);
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw ExceptionKit.wrapRuntime((Throwable)e);
            }
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw ExceptionKit.wrapRuntime((Throwable)e1);
            }
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static Dimension getDimension(FontMetrics metrics, String text) {
        int width = metrics.stringWidth(text);
        int height = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        return new Dimension(width, height);
    }

    public static Rectangle2D getRectangle(String text, Font font) {
        return font.getStringBounds(text, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }
}

