/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.miaixz.bus.core.io.file.FileType;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ColorKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.image.ImageKit;

public class ImageRemoval {
    public static String[] IMAGES_TYPE = new String[]{"jpg", "jpeg", "png"};

    public static void backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        ImageRemoval.backgroundRemoval(new File(inputPath), new File(outputPath), tolerance);
    }

    public static void backgroundRemoval(File input, File output, int tolerance) {
        ImageRemoval.backgroundRemoval(input, output, null, tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backgroundRemoval(File input, File output, Color override, int tolerance) {
        ImageRemoval.fileTypeValidation(input, IMAGES_TYPE);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageKit.read(input);
            ImageKit.write(ImageRemoval.backgroundRemoval(bufferedImage, override, tolerance), output);
        }
        finally {
            ImageKit.flush(bufferedImage);
        }
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        tolerance = Math.min(255, Math.max(tolerance, 0));
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        Object[] removeRgb = ImageRemoval.getRemoveRgb(bufferedImage);
        String mainColor = ImageRemoval.getMainColor(bufferedImage);
        boolean alpha = false;
        for (int y = image.getMinY(); y < image.getHeight(); ++y) {
            for (int x = image.getMinX(); x < image.getWidth(); ++x) {
                boolean isTrue;
                int rgb = image.getRGB(x, y);
                String hex = ColorKit.toHex((int)((rgb & 0xFF0000) >> 16), (int)((rgb & 0xFF00) >> 8), (int)(rgb & 0xFF));
                boolean bl = isTrue = ArrayKit.contains((Object[])removeRgb, (Object)hex) || ImageRemoval.areColorsWithinTolerance(ImageRemoval.hexToRgb(mainColor), new Color(Integer.parseInt(hex.substring(1), 16)), tolerance);
                if (isTrue) {
                    rgb = override == null ? 0x1000000 | rgb & 0xFFFFFF : override.getRGB();
                }
                image.setRGB(x, y, rgb);
            }
        }
        graphics.drawImage(image, 0, 0, imageIcon.getImageObserver());
        return image;
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        try {
            return ImageRemoval.backgroundRemoval(ImageIO.read(new ByteArrayInputStream(outputStream.toByteArray())), override, tolerance);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private static String[] getRemoveRgb(BufferedImage image) {
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int leftUpPixel = image.getRGB(1, 1);
        String leftUp = ColorKit.toHex((int)((leftUpPixel & 0xFF0000) >> 16), (int)((leftUpPixel & 0xFF00) >> 8), (int)(leftUpPixel & 0xFF));
        int upMiddlePixel = image.getRGB(width / 2, 1);
        String upMiddle = ColorKit.toHex((int)((upMiddlePixel & 0xFF0000) >> 16), (int)((upMiddlePixel & 0xFF00) >> 8), (int)(upMiddlePixel & 0xFF));
        int rightUpPixel = image.getRGB(width, 1);
        String rightUp = ColorKit.toHex((int)((rightUpPixel & 0xFF0000) >> 16), (int)((rightUpPixel & 0xFF00) >> 8), (int)(rightUpPixel & 0xFF));
        int rightMiddlePixel = image.getRGB(width, height / 2);
        String rightMiddle = ColorKit.toHex((int)((rightMiddlePixel & 0xFF0000) >> 16), (int)((rightMiddlePixel & 0xFF00) >> 8), (int)(rightMiddlePixel & 0xFF));
        int lowerRightPixel = image.getRGB(width, height);
        String lowerRight = ColorKit.toHex((int)((lowerRightPixel & 0xFF0000) >> 16), (int)((lowerRightPixel & 0xFF00) >> 8), (int)(lowerRightPixel & 0xFF));
        int lowerMiddlePixel = image.getRGB(width / 2, height);
        String lowerMiddle = ColorKit.toHex((int)((lowerMiddlePixel & 0xFF0000) >> 16), (int)((lowerMiddlePixel & 0xFF00) >> 8), (int)(lowerMiddlePixel & 0xFF));
        int leftLowerPixel = image.getRGB(1, height);
        String leftLower = ColorKit.toHex((int)((leftLowerPixel & 0xFF0000) >> 16), (int)((leftLowerPixel & 0xFF00) >> 8), (int)(leftLowerPixel & 0xFF));
        int leftMiddlePixel = image.getRGB(1, height / 2);
        String leftMiddle = ColorKit.toHex((int)((leftMiddlePixel & 0xFF0000) >> 16), (int)((leftMiddlePixel & 0xFF00) >> 8), (int)(leftMiddlePixel & 0xFF));
        return new String[]{leftUp, upMiddle, rightUp, rightMiddle, lowerRight, lowerMiddle, leftLower, leftMiddle};
    }

    public static Color hexToRgb(String hex) {
        return new Color(Integer.parseInt(hex.substring(1), 16));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, int tolerance) {
        return ImageRemoval.areColorsWithinTolerance(color1, color2, new Color(tolerance, tolerance, tolerance));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, Color tolerance) {
        return color1.getRed() - color2.getRed() < tolerance.getRed() && color1.getRed() - color2.getRed() > -tolerance.getRed() && color1.getBlue() - color2.getBlue() < tolerance.getBlue() && color1.getBlue() - color2.getBlue() > -tolerance.getBlue() && color1.getGreen() - color2.getGreen() < tolerance.getGreen() && color1.getGreen() - color2.getGreen() > -tolerance.getGreen();
    }

    public static String getMainColor(String input) {
        return ImageRemoval.getMainColor(new File(input));
    }

    public static String getMainColor(File input) {
        try {
            return ImageRemoval.getMainColor(ImageIO.read(input));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static String getMainColor(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("\u56fe\u7247\u6d41\u662f\u7a7a\u7684");
        }
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int y = bufferedImage.getMinY(); y < bufferedImage.getHeight(); ++y) {
            for (int x = bufferedImage.getMinX(); x < bufferedImage.getWidth(); ++x) {
                int n = bufferedImage.getRGB(x, y);
                list.add((CallSite)((Object)(((n & 0xFF0000) >> 16) + "-" + ((n & 0xFF00) >> 8) + "-" + (n & 0xFF))));
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size(), 1.0f);
        for (String string : list) {
            Integer integer = (Integer)map.get(string);
            if (integer == null) {
                integer = 1;
            } else {
                Integer n = integer;
                integer = integer + 1;
            }
            map.put(string, integer);
        }
        String max = "";
        long l = 0L;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Integer temp = (Integer)entry.getValue();
            if (!StringKit.isBlank((CharSequence)max) && (long)temp.intValue() <= l) continue;
            max = key;
            l = temp.intValue();
        }
        String[] strings = max.split("-");
        int rgbLength = 3;
        if (strings.length == 3) {
            return ColorKit.toHex((int)Integer.parseInt(strings[0]), (int)Integer.parseInt(strings[1]), (int)Integer.parseInt(strings[2]));
        }
        return "";
    }

    private static void fileTypeValidation(File input, String[] imagesType) {
        Assert.isTrue((boolean)input.exists(), (String)"File {} not exist!", (Object[])new Object[]{input});
        String type = FileType.getType((File)input);
        if (!ArrayKit.contains((Object[])imagesType, (Object)type)) {
            throw new IllegalArgumentException(StringKit.format((CharSequence)"Format {} of File not supported!", (Object[])new Object[]{type}));
        }
    }
}

