/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.nlp.provider.jcseg;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.dic.DictionaryFactory;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.nlp.NLPProvider;
import org.miaixz.bus.extra.nlp.NLPResult;
import org.miaixz.bus.extra.nlp.provider.jcseg.JcsegResult;

public class JcsegProvider
implements NLPProvider {
    private final SegmenterConfig config;
    private final ADictionary dic;

    public JcsegProvider() {
        this(new SegmenterConfig(true));
    }

    public JcsegProvider(SegmenterConfig config) {
        this.config = config;
        this.dic = DictionaryFactory.createSingletonDictionary((SegmenterConfig)config);
    }

    @Override
    public NLPResult parse(CharSequence text) {
        ISegment segment = ISegment.COMPLEX.factory.create(this.config, this.dic);
        try {
            segment.reset((Reader)new StringReader(StringKit.toString((CharSequence)text)));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return new JcsegResult(segment);
    }
}

