/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.pinyin;

import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.loader.spi.ServiceLoader;
import org.miaixz.bus.core.xyz.SPIKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.pinyin.PinyinProvider;
import org.miaixz.bus.logger.Logger;

public class PinyinFactory {
    public static PinyinProvider getEngine() {
        PinyinProvider engine = (PinyinProvider)Instances.get((String)PinyinProvider.class.getName(), PinyinFactory::createEngine);
        Logger.debug((String)"Use [{}] Pinyin Engine As Default.", (Object[])new Object[]{StringKit.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    public static PinyinProvider createEngine() {
        return PinyinFactory.doCreateEngine();
    }

    public static PinyinProvider createEngine(String engineName) throws InternalException {
        if (!StringKit.endWithIgnoreCase((CharSequence)engineName, (CharSequence)"Engine")) {
            engineName = (String)engineName + "Engine";
        }
        ServiceLoader list = SPIKit.loadList(PinyinProvider.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StringKit.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)engineName)) continue;
            return (PinyinProvider)list.getService(serviceName);
        }
        throw new InternalException("No such engine named: " + (String)engineName);
    }

    private static PinyinProvider doCreateEngine() {
        PinyinProvider engine = (PinyinProvider)SPIKit.loadFirstAvailable(PinyinProvider.class);
        if (null != engine) {
            return engine;
        }
        throw new InternalException("No pinyin jar found !Please add one of it to your project !");
    }
}

