/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.pinyin.provider.pinyin4j;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.extra.pinyin.PinyinProvider;

public class Pinyin4JProvider
implements PinyinProvider {
    private HanyuPinyinOutputFormat format;

    public Pinyin4JProvider() {
        this(null);
    }

    public Pinyin4JProvider(HanyuPinyinOutputFormat format) {
        this.init(format);
    }

    public void init(HanyuPinyinOutputFormat format) {
        if (null == format) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        Object result;
        try {
            Object[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            result = ArrayKit.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            result = String.valueOf(c);
        }
        return result;
    }

    @Override
    public String getPinyin(String text, String separator) {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        int strLen = text.length();
        try {
            for (int i = 0; i < strLen; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append(separator);
                }
                Object[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)text.charAt(i), (HanyuPinyinOutputFormat)this.format);
                if (ArrayKit.isEmpty((Object[])pinyinStringArray)) {
                    result.append(text.charAt(i));
                    continue;
                }
                result.append((String)pinyinStringArray[0]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new InternalException((Throwable)e);
        }
        return result.toString();
    }
}

