/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.DecodeHintType;
import com.google.zxing.common.BitMatrix;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.qrcode.QrAsciiArt;
import org.miaixz.bus.extra.qrcode.QrConfig;
import org.miaixz.bus.extra.qrcode.QrDecoder;
import org.miaixz.bus.extra.qrcode.QrEncoder;
import org.miaixz.bus.extra.qrcode.QrImage;
import org.miaixz.bus.extra.qrcode.QrSVG;

public class QrCodeKit {
    public static final String QR_TYPE_SVG = "svg";
    public static final String QR_TYPE_TXT = "txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateAsBase64DataUri(String content, QrConfig qrConfig, String imageType) {
        BufferedImage img = null;
        try {
            img = QrCodeKit.generate(content, qrConfig);
            String string = ImageKit.toBase64DataUri(img, imageType);
            return string;
        }
        finally {
            ImageKit.flush(img);
        }
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, config, "png", out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generate(String content, int width, int height, File targetFile) {
        BufferedImage image = null;
        try {
            image = QrCodeKit.generate(content, width, height);
            ImageKit.write(image, targetFile);
        }
        catch (Throwable throwable) {
            ImageKit.flush(image);
            throw throwable;
        }
        ImageKit.flush(image);
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generate(String content, QrConfig config, File targetFile) {
        BufferedImage image = null;
        try {
            image = QrCodeKit.generate(content, config);
            ImageKit.write(image, targetFile);
        }
        finally {
            ImageKit.flush(image);
        }
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        BufferedImage img = null;
        try {
            img = QrCodeKit.generate(content, width, height);
            ImageKit.write((Image)img, imageType, out);
        }
        catch (Throwable throwable) {
            ImageKit.flush(img);
            throw throwable;
        }
        ImageKit.flush(img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        BufferedImage image = null;
        try {
            image = QrCodeKit.generate(content, config);
            ImageKit.write((Image)image, imageType, out);
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeKit.generate(content, QrConfig.of(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return new QrImage(content, (QrConfig)ObjectKit.defaultIfNull((Object)config, QrConfig::new));
    }

    public static BitMatrix encode(CharSequence content, QrConfig config) {
        return QrEncoder.of(config).encode(content);
    }

    public static String decode(InputStream qrCodeInputstream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(qrCodeInputstream);
            String string = QrCodeKit.decode(image);
            return string;
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static String decode(File qrCodeFile) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(qrCodeFile);
            String string = QrCodeKit.decode(image);
            return string;
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static String decode(Image image) {
        return QrCodeKit.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrDecoder.of(isTryHarder, isPureBarcode).decode(image);
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        return QrDecoder.of(hints).decode(image);
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    public static String generateAsSvg(String content, QrConfig qrConfig) {
        return QrCodeKit.toSVG(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String toSVG(BitMatrix matrix, QrConfig config) {
        return new QrSVG(matrix, config).toString();
    }

    public static String generateAsAsciiArt(String content, QrConfig qrConfig) {
        return QrCodeKit.toAsciiArt(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String toAsciiArt(BitMatrix bitMatrix, QrConfig qrConfig) {
        return new QrAsciiArt(bitMatrix, qrConfig).toString();
    }
}

