/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import org.miaixz.bus.core.codec.Encoder;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.qrcode.QrCodeException;
import org.miaixz.bus.extra.qrcode.QrConfig;

public class QrEncoder
implements Encoder<CharSequence, BitMatrix> {
    private final QrConfig config;

    public QrEncoder(QrConfig config) {
        this.config = (QrConfig)ObjectKit.defaultIfNull((Object)config, QrConfig::of);
    }

    public static QrEncoder of(QrConfig config) {
        return new QrEncoder(config);
    }

    public BitMatrix encode(CharSequence content) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        try {
            bitMatrix = multiFormatWriter.encode(StringKit.toString((CharSequence)content), this.config.format, this.config.width, this.config.height, this.config.toHints());
        }
        catch (WriterException e) {
            throw new QrCodeException(e);
        }
        return bitMatrix;
    }
}

