/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh;

import java.io.IOException;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.extra.ssh.Connector;

public class MinaKit {
    public static SshClient openClient() {
        SshClient sshClient = SshClient.setUpDefaultClient();
        sshClient.start();
        return sshClient;
    }

    public static ClientSession openSession(SshClient sshClient, Connector connector) {
        boolean success;
        ClientSession session;
        try {
            session = (ClientSession)((ConnectFuture)sshClient.connect(connector.getUser(), connector.getHost(), connector.getPort()).verify(new CancelOption[0])).getSession();
            session.addPasswordIdentity(connector.getPassword());
            success = ((AuthFuture)session.auth().verify(new CancelOption[0])).isSuccess();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (!success) {
            throw new InternalException("Authentication failed.");
        }
        return session;
    }
}

