/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.template;

import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.SPIKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.template.TemplateConfig;
import org.miaixz.bus.extra.template.TemplateProvider;
import org.miaixz.bus.logger.Logger;

public class TemplateFactory {
    public static TemplateProvider getEngine() {
        TemplateProvider engine = (TemplateProvider)Instances.get((String)TemplateProvider.class.getName(), TemplateFactory::createEngine);
        Logger.debug((String)"Use [{}] Template Engine As Default.", (Object[])new Object[]{StringKit.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    public static TemplateProvider createEngine() {
        return TemplateFactory.createEngine(TemplateConfig.DEFAULT);
    }

    public static TemplateProvider createEngine(TemplateConfig config) {
        return TemplateFactory.doCreateEngine(config);
    }

    private static TemplateProvider doCreateEngine(TemplateConfig config) {
        Class<? extends TemplateProvider> customEngineClass = config.getCustomEngine();
        TemplateProvider engine = null != customEngineClass ? (TemplateProvider)ReflectKit.newInstance(customEngineClass, (Object[])new Object[0]) : (TemplateProvider)SPIKit.loadFirstAvailable(TemplateProvider.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new InternalException("No template found! Please add one of template jar to your project !");
    }
}

