/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.template.provider.beetl;

import java.io.IOException;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.core.resource.WebAppResourceLoader;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.extra.template.Template;
import org.miaixz.bus.extra.template.TemplateConfig;
import org.miaixz.bus.extra.template.TemplateProvider;
import org.miaixz.bus.extra.template.provider.beetl.BeetlTemplate;

public class BeetlProvider
implements TemplateProvider {
    private GroupTemplate engine;

    public BeetlProvider() {
    }

    public BeetlProvider(TemplateConfig config) {
        this.init(config);
    }

    public BeetlProvider(GroupTemplate engine) {
        this.init(engine);
    }

    private static GroupTemplate createEngine(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                return BeetlProvider.createGroupTemplate(new ClasspathResourceLoader(config.getPath(), config.getCharsetString()));
            }
            case FILE: {
                return BeetlProvider.createGroupTemplate(new FileResourceLoader(config.getPath(), config.getCharsetString()));
            }
            case WEB_ROOT: {
                return BeetlProvider.createGroupTemplate(new WebAppResourceLoader(config.getPath(), config.getCharsetString()));
            }
            case STRING: {
                return BeetlProvider.createGroupTemplate(new StringTemplateResourceLoader());
            }
            case COMPOSITE: {
                return BeetlProvider.createGroupTemplate(new CompositeResourceLoader());
            }
        }
        return new GroupTemplate();
    }

    private static GroupTemplate createGroupTemplate(ResourceLoader<?> loader) {
        try {
            return BeetlProvider.createGroupTemplate(loader, Configuration.defaultConfiguration());
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private static GroupTemplate createGroupTemplate(ResourceLoader<?> loader, Configuration conf) {
        return new GroupTemplate(loader, conf);
    }

    @Override
    public TemplateProvider init(TemplateConfig config) {
        this.init(BeetlProvider.createEngine(config));
        return this;
    }

    private void init(GroupTemplate engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return BeetlTemplate.wrap(this.engine.getTemplate((Object)resource));
    }

    public GroupTemplate getRaw() {
        return this.engine;
    }
}

