/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.captcha.provider;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.miaixz.bus.core.xyz.ColorKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.extra.captcha.AbstractProvider;
import org.miaixz.bus.extra.captcha.strategy.CodeStrategy;
import org.miaixz.bus.extra.captcha.strategy.RandomStrategy;
import org.miaixz.bus.extra.image.ImageKit;

public class CircleProvider
extends AbstractProvider {
    private static final long serialVersionUID = -1L;

    public CircleProvider(int width, int height) {
        this(width, height, 5);
    }

    public CircleProvider(int width, int height, int codeCount) {
        this(width, height, codeCount, 15);
    }

    public CircleProvider(int width, int height, int codeCount, int interfereCount) {
        this(width, height, new RandomStrategy(codeCount), interfereCount);
    }

    public CircleProvider(int width, int height, CodeStrategy generator, int interfereCount) {
        super(width, height, generator, interfereCount);
    }

    public CircleProvider(int width, int height, int codeCount, int interfereCount, float sizeBaseHeight) {
        super(width, height, new RandomStrategy(codeCount), interfereCount, sizeBaseHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, null == this.background ? 6 : 1);
        Graphics2D g = ImageKit.createGraphics(image, this.background);
        try {
            this.drawInterfere(g);
            this.drawString(g, code);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    private void drawString(Graphics2D g, String code) {
        if (null != this.textAlpha) {
            g.setComposite(this.textAlpha);
        }
        ImageKit.drawStringColourful(g, code, this.font, this.width, this.height);
    }

    private void drawInterfere(Graphics2D g) {
        ThreadLocalRandom random = RandomKit.getRandom();
        for (int i = 0; i < this.interfereCount; ++i) {
            g.setColor(ColorKit.randomColor((Random)random));
            g.drawOval(random.nextInt(this.width), random.nextInt(this.height), random.nextInt(this.height >> 1), random.nextInt(this.height >> 1));
        }
    }
}

