/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.compress.archiver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.compress.archiver.Archiver;

public class SevenZArchiver
implements Archiver {
    private final SevenZOutputFile sevenZOutputFile;
    private SeekableByteChannel channel;
    private OutputStream out;

    public SevenZArchiver(File file) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(file);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public SevenZArchiver(OutputStream out) {
        this.out = out;
        this.channel = new SeekableInMemoryByteChannel();
        try {
            this.sevenZOutputFile = new SevenZOutputFile(this.channel);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public SevenZArchiver(SeekableByteChannel channel) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(channel);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public SevenZOutputFile getSevenZOutputFile() {
        return this.sevenZOutputFile;
    }

    @Override
    public SevenZArchiver add(File file, String path, Function<String, String> fileNameEditor, Predicate<File> filter) {
        try {
            this.addInternal(file, path, fileNameEditor, filter);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public SevenZArchiver finish() {
        try {
            this.sevenZOutputFile.finish();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != this.out && this.channel instanceof SeekableInMemoryByteChannel) {
            try {
                this.out.write(((SeekableInMemoryByteChannel)this.channel).array());
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.sevenZOutputFile});
    }

    private void addInternal(File file, String path, Function<String, String> fileNameEditor, Predicate<File> filter) throws IOException {
        Object entryName;
        if (null != filter && !filter.test(file)) {
            return;
        }
        SevenZOutputFile out = this.sevenZOutputFile;
        Object object = entryName = null == fileNameEditor ? file.getName() : fileNameEditor.apply(file.getName());
        if (StringKit.isNotEmpty((CharSequence)path)) {
            entryName = StringKit.addSuffixIfNot((CharSequence)path, (CharSequence)"/") + (String)entryName;
        }
        out.putArchiveEntry(out.createArchiveEntry(file, (String)entryName));
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ArrayKit.isNotEmpty((Object[])files)) {
                for (Object childFile : files) {
                    this.addInternal((File)childFile, (String)entryName, fileNameEditor, filter);
                }
            }
        } else {
            if (file.isFile()) {
                out.write(FileKit.readBytes((File)file));
            }
            out.closeArchiveEntry();
        }
    }
}

