/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.compress.extractor;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public class Seven7EntryInputStream
extends InputStream {
    private final SevenZFile sevenZFile;
    private final long size;
    private long readSize = 0L;

    public Seven7EntryInputStream(SevenZFile sevenZFile, SevenZArchiveEntry entry) {
        this(sevenZFile, entry.getSize());
    }

    public Seven7EntryInputStream(SevenZFile sevenZFile, long size) {
        this.sevenZFile = sevenZFile;
        this.size = size;
    }

    @Override
    public int available() throws IOException {
        try {
            return Math.toIntExact(this.size);
        }
        catch (ArithmeticException e) {
            throw new IOException("Entry size is too large!(max than Integer.MAX)", e);
        }
    }

    public long getReadSize() {
        return this.readSize;
    }

    @Override
    public int read() throws IOException {
        ++this.readSize;
        return this.sevenZFile.read();
    }
}

