/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.compress.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.StandardCopyOption;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.compress.extractor.Extractor;

public class StreamExtractor
implements Extractor {
    private final ArchiveInputStream<?> in;

    public StreamExtractor(Charset charset, File file) {
        this(charset, null, file);
    }

    public StreamExtractor(Charset charset, String archiverName, File file) {
        this(charset, archiverName, FileKit.getInputStream((File)file));
    }

    public StreamExtractor(Charset charset, InputStream in) {
        this(charset, null, in);
    }

    public StreamExtractor(Charset charset, String archiverName, InputStream in) {
        block7: {
            if (in instanceof ArchiveInputStream) {
                this.in = (ArchiveInputStream)in;
                return;
            }
            ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
            try {
                in = IoKit.toBuffered((InputStream)in);
                if (StringKit.isBlank((CharSequence)archiverName)) {
                    this.in = factory.createArchiveInputStream(in);
                    break block7;
                }
                if ("tgz".equalsIgnoreCase(archiverName) || "tar.gz".equalsIgnoreCase(archiverName)) {
                    try {
                        this.in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in));
                        break block7;
                    }
                    catch (IOException e) {
                        throw new InternalException((Throwable)e);
                    }
                }
                this.in = factory.createArchiveInputStream(archiverName, in);
            }
            catch (ArchiveException e) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw new InternalException((Throwable)e);
            }
        }
    }

    @Override
    public InputStream getFirst(Predicate<ArchiveEntry> predicate) {
        ArchiveInputStream<?> in = this.in;
        try {
            ArchiveEntry entry;
            while (null != (entry = in.getNextEntry())) {
                if (null != predicate && !predicate.test(entry) || entry.isDirectory() || !in.canReadEntryData(entry)) continue;
                return in;
            }
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return null;
    }

    @Override
    public void extract(File targetDir, Predicate<ArchiveEntry> predicate) {
        try {
            this.extractInternal(targetDir, predicate);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.close();
        }
    }

    private void extractInternal(File targetDir, Predicate<ArchiveEntry> predicate) throws IOException {
        ArchiveEntry entry;
        Assert.isTrue((null != targetDir && (!targetDir.exists() || targetDir.isDirectory()) ? 1 : 0) != 0, (String)"target must be dir.", (Object[])new Object[0]);
        ArchiveInputStream<?> in = this.in;
        while (null != (entry = in.getNextEntry())) {
            if (null != predicate && !predicate.test(entry) || !in.canReadEntryData(entry)) continue;
            File outItemFile = FileKit.file((File)targetDir, (String)entry.getName());
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileKit.copy(in, (File)outItemFile, (StandardCopyOption[])new StandardCopyOption[0]);
        }
    }

    @Override
    public void close() {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.in});
    }
}

