/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ftp;

import java.io.File;
import java.util.ArrayList;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.NetKit;

public class SimpleFtpServer {
    private final FtpServerFactory serverFactory = new FtpServerFactory();
    private final ListenerFactory listenerFactory = new ListenerFactory();

    public static SimpleFtpServer of() {
        return new SimpleFtpServer();
    }

    public FtpServerFactory getServerFactory() {
        return this.serverFactory;
    }

    public SimpleFtpServer setConnectionConfig(ConnectionConfig connectionConfig) {
        this.serverFactory.setConnectionConfig(connectionConfig);
        return this;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public SimpleFtpServer setPort(int port) {
        Assert.isTrue((boolean)NetKit.isValidPort((int)port), (String)"Invalid port!", (Object[])new Object[0]);
        this.listenerFactory.setPort(port);
        return this;
    }

    public UserManager getUserManager() {
        return this.serverFactory.getUserManager();
    }

    public SimpleFtpServer setUserManager(UserManager userManager) {
        this.serverFactory.setUserManager(userManager);
        return this;
    }

    public SimpleFtpServer addUser(User user) {
        try {
            this.getUserManager().save(user);
        }
        catch (FtpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public SimpleFtpServer addAnonymous(String homePath) {
        BaseUser user = new BaseUser();
        user.setName("anonymous");
        user.setHomeDirectory(homePath);
        ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
        authorities.add(new WritePermission());
        user.setAuthorities(authorities);
        return this.addUser((User)user);
    }

    public SimpleFtpServer delUser(String userName) {
        try {
            this.getUserManager().delete(userName);
        }
        catch (FtpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public SimpleFtpServer setSsl(SslConfiguration ssl) {
        this.listenerFactory.setSslConfiguration(ssl);
        this.listenerFactory.setImplicitSsl(true);
        return this;
    }

    public SimpleFtpServer setSsl(File keystoreFile, String password) {
        SslConfigurationFactory sslFactory = new SslConfigurationFactory();
        sslFactory.setKeystoreFile(keystoreFile);
        sslFactory.setKeystorePassword(password);
        return this.setSsl(sslFactory.createSslConfiguration());
    }

    public SimpleFtpServer setUsersConfig(File propertiesFile) {
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        userManagerFactory.setFile(propertiesFile);
        return this.setUserManager(userManagerFactory.createUserManager());
    }

    public SimpleFtpServer addFtplet(String name, Ftplet ftplet) {
        this.serverFactory.getFtplets().put(name, ftplet);
        return this;
    }

    public void start() {
        this.serverFactory.addListener("default", this.listenerFactory.createListener());
        try {
            this.serverFactory.createServer().start();
        }
        catch (FtpException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

