/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh.provider.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.ssh.Connector;
import org.miaixz.bus.extra.ssh.JschKit;
import org.miaixz.bus.extra.ssh.Session;
import org.miaixz.bus.extra.ssh.provider.jsch.ChannelType;
import org.miaixz.bus.extra.ssh.provider.jsch.JschSftp;

public class JschSession
implements Session {
    private final com.jcraft.jsch.Session raw;
    private final long timeout;

    public JschSession(Connector connector) {
        this(JschKit.openSession(connector), connector.getTimeout());
    }

    public JschSession(com.jcraft.jsch.Session raw, long timeout) {
        this.raw = raw;
        this.timeout = timeout;
    }

    public com.jcraft.jsch.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && this.raw.isConnected();
    }

    @Override
    public void close() throws IOException {
        JschKit.close(this.raw);
    }

    @Override
    public void bindLocalPort(InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws InternalException {
        try {
            this.raw.setPortForwardingL(localAddress.getHostName(), localAddress.getPort(), remoteAddress.getHostName(), remoteAddress.getPort());
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e, "From [{}] mapping to [{}] error\uff01", new Object[]{localAddress, remoteAddress});
        }
    }

    @Override
    public void unBindLocalPort(InetSocketAddress localAddress) {
        try {
            this.raw.delPortForwardingL(localAddress.getHostName(), localAddress.getPort());
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void bindRemotePort(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws InternalException {
        try {
            this.raw.setPortForwardingR(remoteAddress.getHostName(), remoteAddress.getPort(), localAddress.getHostName(), localAddress.getPort());
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e, "From [{}] mapping to [{}] error\uff01", new Object[]{remoteAddress, localAddress});
        }
    }

    @Override
    public void unBindRemotePort(InetSocketAddress remoteAddress) {
        try {
            this.raw.delPortForwardingR(remoteAddress.getHostName(), remoteAddress.getPort());
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public Channel createChannel(ChannelType channelType) {
        return JschKit.createChannel(this.raw, channelType, this.timeout);
    }

    public ChannelShell openShell() {
        return (ChannelShell)this.openChannel(ChannelType.SHELL);
    }

    public Channel openChannel(ChannelType channelType) {
        return JschKit.openChannel(this.raw, channelType, this.timeout);
    }

    public JschSftp openSftp(Charset charset) {
        return new JschSftp(this.raw, charset, this.timeout);
    }

    public String exec(String cmd, Charset charset) {
        return this.exec(cmd, charset, System.err);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exec(String cmd, Charset charset, OutputStream errStream) {
        String string;
        if (null == charset) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        ChannelExec channel = (ChannelExec)this.createChannel(ChannelType.EXEC);
        channel.setCommand(ByteKit.toBytes((CharSequence)cmd, (Charset)charset));
        channel.setInputStream(null);
        channel.setErrStream(errStream);
        InputStream in = null;
        try {
            channel.connect();
            in = channel.getInputStream();
            string = IoKit.read((InputStream)in, (Charset)charset);
        }
        catch (IOException e) {
            try {
                throw new InternalException((Throwable)e);
                catch (JSchException e2) {
                    throw new InternalException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                if (channel.isConnected()) {
                    channel.disconnect();
                }
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        if (channel.isConnected()) {
            channel.disconnect();
        }
        return string;
    }

    public String execByShell(String cmd, Charset charset) {
        String string;
        ChannelShell shell = this.openShell();
        shell.setPty(true);
        OutputStream out = null;
        InputStream in = null;
        try {
            out = shell.getOutputStream();
            in = shell.getInputStream();
            out.write(ByteKit.toBytes((CharSequence)cmd, (Charset)charset));
            out.flush();
            string = IoKit.read((InputStream)in, (Charset)charset);
        }
        catch (IOException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                if (shell.isConnected()) {
                    shell.disconnect();
                }
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        if (shell.isConnected()) {
            shell.disconnect();
        }
        return string;
    }
}

