/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.template.provider.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.extra.template.Template;
import org.miaixz.bus.extra.template.TemplateConfig;
import org.miaixz.bus.extra.template.TemplateProvider;
import org.miaixz.bus.extra.template.provider.freemarker.FreemarkerTemplate;
import org.miaixz.bus.extra.template.provider.freemarker.SimpleStringTemplateLoader;

public class FreemarkerProvider
implements TemplateProvider {
    private Configuration cfg;

    public FreemarkerProvider() {
    }

    public FreemarkerProvider(TemplateConfig config) {
        this.init(config);
    }

    public FreemarkerProvider(Configuration freemarkerCfg) {
        this.init(freemarkerCfg);
    }

    private static Configuration createCfg(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setLocalizedLookup(false);
        cfg.setDefaultEncoding(config.getCharset().toString());
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ClassKit.getClassLoader(), config.getPath()));
                break;
            }
            case FILE: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileKit.file((String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            case WEB_ROOT: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileKit.file((File)FileKit.getWebRoot(), (String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            case STRING: {
                cfg.setTemplateLoader((TemplateLoader)new SimpleStringTemplateLoader());
                break;
            }
        }
        return cfg;
    }

    @Override
    public TemplateProvider init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.init(FreemarkerProvider.createCfg(config));
        return this;
    }

    private void init(Configuration freemarkerCfg) {
        this.cfg = freemarkerCfg;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.cfg) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return FreemarkerTemplate.wrap(this.cfg.getTemplate(resource));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public Configuration getRaw() {
        return this.cfg;
    }
}

