/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.template.provider.thymeleaf;

import java.io.File;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.template.Template;
import org.miaixz.bus.extra.template.TemplateConfig;
import org.miaixz.bus.extra.template.TemplateProvider;
import org.miaixz.bus.extra.template.provider.thymeleaf.ThymeleafTemplate;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ThymeleafProvider
implements TemplateProvider {
    TemplateEngine engine;
    TemplateConfig config;

    public ThymeleafProvider() {
    }

    public ThymeleafProvider(TemplateConfig config) {
        this.init(config);
    }

    public ThymeleafProvider(TemplateEngine engine) {
        this.init(engine);
    }

    private static TemplateEngine createEngine(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        StringTemplateResolver resolver = switch (config.getResourceMode()) {
            case TemplateConfig.ResourceMode.CLASSPATH -> {
                ClassLoaderTemplateResolver classLoaderResolver = new ClassLoaderTemplateResolver();
                classLoaderResolver.setCharacterEncoding(config.getCharsetString());
                classLoaderResolver.setTemplateMode(TemplateMode.HTML);
                classLoaderResolver.setPrefix(StringKit.addSuffixIfNot((CharSequence)config.getPath(), (CharSequence)"/"));
                yield classLoaderResolver;
            }
            case TemplateConfig.ResourceMode.FILE -> {
                FileTemplateResolver fileResolver = new FileTemplateResolver();
                fileResolver.setCharacterEncoding(config.getCharsetString());
                fileResolver.setTemplateMode(TemplateMode.HTML);
                fileResolver.setPrefix(StringKit.addSuffixIfNot((CharSequence)config.getPath(), (CharSequence)"/"));
                yield fileResolver;
            }
            case TemplateConfig.ResourceMode.WEB_ROOT -> {
                FileTemplateResolver webRootResolver = new FileTemplateResolver();
                webRootResolver.setCharacterEncoding(config.getCharsetString());
                webRootResolver.setTemplateMode(TemplateMode.HTML);
                webRootResolver.setPrefix(StringKit.addSuffixIfNot((CharSequence)FileKit.getAbsolutePath((File)FileKit.file((File)FileKit.getWebRoot(), (String)config.getPath())), (CharSequence)"/"));
                yield webRootResolver;
            }
            case TemplateConfig.ResourceMode.STRING -> new StringTemplateResolver();
            default -> new DefaultTemplateResolver();
        };
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)resolver);
        return engine;
    }

    @Override
    public TemplateProvider init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.config = config;
        this.init(ThymeleafProvider.createEngine(config));
        return this;
    }

    private void init(TemplateEngine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return ThymeleafTemplate.wrap(this.engine, resource, null == this.config ? null : this.config.getCharset());
    }

    public TemplateEngine getRaw() {
        return this.engine;
    }
}

