/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.captcha;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.UrlKit;
import org.miaixz.bus.extra.captcha.CaptchaProvider;
import org.miaixz.bus.extra.captcha.strategy.CodeStrategy;
import org.miaixz.bus.extra.captcha.strategy.RandomStrategy;
import org.miaixz.bus.extra.image.ImageKit;

public abstract class AbstractProvider
implements CaptchaProvider {
    private static final long serialVersionUID = -1L;
    protected int width;
    protected int height;
    protected int interfereCount;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;
    protected CodeStrategy generator;
    protected Color background = Color.WHITE;
    protected AlphaComposite textAlpha;

    public AbstractProvider(int width, int height, int codeCount, int interfereCount) {
        this(width, height, new RandomStrategy(codeCount), interfereCount);
    }

    public AbstractProvider(int width, int height, CodeStrategy generator, int interfereCount) {
        this(width, height, generator, interfereCount, 0.75f);
    }

    public AbstractProvider(int width, int height, CodeStrategy generator, int interfereCount, float sizeBaseHeight) {
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.interfereCount = interfereCount;
        this.font = new Font("SansSerif", 0, (int)((float)this.height * sizeBaseHeight));
    }

    @Override
    public void create() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Image image = null;
        try {
            image = this.createImage(this.code);
            ImageKit.writePng(image, out);
        }
        catch (Throwable throwable) {
            ImageKit.flush(image);
            throw throwable;
        }
        ImageKit.flush(image);
        this.imageBytes = out.toByteArray();
    }

    protected void generateCode() {
        this.code = this.generator.generate();
    }

    protected abstract Image createImage(String var1);

    @Override
    public String get() {
        if (null == this.code) {
            this.create();
        }
        return this.code;
    }

    @Override
    public boolean verify(String userInputCode) {
        return this.generator.verify(this.get(), userInputCode);
    }

    public void write(String path) throws InternalException {
        this.write(FileKit.touch((String)path));
    }

    public void write(File file) throws InternalException {
        try (BufferedOutputStream out = FileKit.getOutputStream((File)file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void write(OutputStream out) {
        IoKit.write((OutputStream)out, (boolean)false, (byte[])this.getImageBytes());
    }

    public byte[] getImageBytes() {
        if (null == this.imageBytes) {
            this.create();
        }
        return this.imageBytes;
    }

    public BufferedImage getImage() {
        return ImageKit.read(IoKit.toStream((byte[])this.getImageBytes()));
    }

    public String getImageBase64() {
        return Base64.encode((byte[])this.getImageBytes());
    }

    public String getImageBase64Data() {
        return UrlKit.getDataUriBase64((String)"image/png", (String)this.getImageBase64());
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public CodeStrategy getGenerator() {
        return this.generator;
    }

    public void setGenerator(CodeStrategy generator) {
        this.generator = generator;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setTextAlpha(float textAlpha) {
        this.textAlpha = AlphaComposite.getInstance(3, textAlpha);
    }
}

