/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ftp;

import java.io.File;
import java.util.List;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.ftp.Ftp;
import org.miaixz.bus.extra.ftp.FtpConfig;

public abstract class AbstractFtp
implements Ftp {
    protected FtpConfig ftpConfig;

    protected AbstractFtp(FtpConfig config) {
        this.ftpConfig = config;
    }

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (StringKit.isEmpty((CharSequence)nameToFind)) {
            return false;
        }
        return CollKit.contains(names, nameToFind::equalsIgnoreCase);
    }

    @Override
    public FtpConfig getConfig() {
        return this.ftpConfig;
    }

    @Override
    public boolean exist(String path) {
        List<String> names;
        if (StringKit.isBlank((CharSequence)path)) {
            return false;
        }
        if (this.isDir(path)) {
            return true;
        }
        if (CharKit.isFileSeparator((char)path.charAt(path.length() - 1))) {
            return false;
        }
        String fileName = FileName.getName((String)path);
        if (".".equals(fileName) || "..".equals(fileName)) {
            return false;
        }
        String dir = (String)StringKit.defaultIfEmpty((CharSequence)StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName), (CharSequence)".");
        if (!this.isDir(dir)) {
            return false;
        }
        try {
            names = this.ls(dir);
        }
        catch (InternalException ignore) {
            return false;
        }
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    @Override
    public void mkDirs(String dir) {
        String[] dirs = StringKit.trim((CharSequence)dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StringKit.isEmpty((CharSequence)dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StringKit.isNotEmpty((CharSequence)s)) continue;
            boolean exist = true;
            try {
                if (!this.cd(s)) {
                    exist = false;
                }
            }
            catch (InternalException e) {
                exist = false;
            }
            if (exist) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public void download(String path, File outFile, String tempFileSuffix) {
        tempFileSuffix = StringKit.isBlank((CharSequence)tempFileSuffix) ? ".temp" : StringKit.addPrefixIfNot((CharSequence)tempFileSuffix, (CharSequence)".");
        String fileName = outFile.isDirectory() ? FileName.getName((String)path) : outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.isDirectory() ? outFile : outFile.getParentFile(), tempFileName);
        try {
            this.download(path, outFile);
            FileKit.rename((File)outFile, (String)fileName, (boolean)true);
        }
        catch (Throwable e) {
            FileKit.remove((File)outFile);
            throw new InternalException(e);
        }
    }
}

