/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ftp;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.miaixz.bus.extra.ssh.Connector;

public class FtpConfig
implements Serializable {
    private static final long serialVersionUID = -1L;
    private Connector connector;
    private Charset charset;
    private long soTimeout;
    private String serverLanguageCode;
    private String systemKey;

    public FtpConfig() {
    }

    public FtpConfig(Connector connector, Charset charset) {
        this(connector, charset, null, null);
    }

    public FtpConfig(Connector connector, Charset charset, String serverLanguageCode, String systemKey) {
        this.connector = connector;
        this.charset = charset;
        this.serverLanguageCode = serverLanguageCode;
        this.systemKey = systemKey;
    }

    public static FtpConfig of() {
        return new FtpConfig();
    }

    public Connector getConnector() {
        return this.connector;
    }

    public FtpConfig setConnector(Connector connector) {
        this.connector = connector;
        return this;
    }

    public FtpConfig setConnectionTimeout(long timeout) {
        if (null == this.connector) {
            this.connector = Connector.of();
        }
        this.connector.setTimeout(timeout);
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public FtpConfig setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public long getSoTimeout() {
        return this.soTimeout;
    }

    public FtpConfig setSoTimeout(long soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public String getServerLanguageCode() {
        return this.serverLanguageCode;
    }

    public FtpConfig setServerLanguageCode(String serverLanguageCode) {
        this.serverLanguageCode = serverLanguageCode;
        return this;
    }

    public String getSystemKey() {
        return this.systemKey;
    }

    public FtpConfig setSystemKey(String systemKey) {
        this.systemKey = systemKey;
        return this;
    }
}

