/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.image;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.io.File;
import java.io.Flushable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.image.ImageText;
import org.miaixz.bus.extra.image.RenderingHintsBuilder;

public class Images
implements Flushable,
Serializable {
    private static final long serialVersionUID = -1L;
    private final BufferedImage srcImage;
    private Image targetImage;
    private String targetImageType;
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;
    private Color backgroundColor;

    public Images(BufferedImage srcImage) {
        this(srcImage, null);
    }

    public Images(BufferedImage srcImage, String targetImageType) {
        this.srcImage = srcImage;
        if (null == targetImageType) {
            targetImageType = srcImage.getType() == 2 || srcImage.getType() == 3 || srcImage.getType() == 6 || srcImage.getType() == 7 ? "png" : "jpg";
        }
        this.targetImageType = targetImageType;
    }

    public static Images from(Path imagePath) {
        return Images.from(imagePath.toFile());
    }

    public static Images from(File imageFile) {
        return new Images(ImageKit.read(imageFile));
    }

    public static Images from(Resource resource) {
        return Images.from(resource.getStream());
    }

    public static Images from(InputStream in) {
        return new Images(ImageKit.read(in));
    }

    public static Images from(ImageInputStream imageStream) {
        return new Images(ImageKit.read(imageStream));
    }

    public static Images from(URL imageUrl) {
        return new Images(ImageKit.read(imageUrl));
    }

    public static Images from(Image image) {
        return new Images(ImageKit.castToBufferedImage(image, "jpg"));
    }

    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        if (degree < 0) {
            degree += 360;
        }
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        double r = Math.sqrt(height * height + width * width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angel_dalta_width = Math.atan((double)height / (double)width);
        double angel_dalta_height = Math.atan((double)width / (double)height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = width + len_dalta_width * 2;
        int des_height = height + len_dalta_height * 2;
        return new Rectangle(des_width, des_height);
    }

    public Images setTargetImageType(String imgType) {
        this.targetImageType = imgType;
        return this;
    }

    public Images setPositionBaseCentre(boolean positionBaseCentre) {
        this.positionBaseCentre = positionBaseCentre;
        return this;
    }

    public Images setQuality(double quality) {
        return this.setQuality((float)quality);
    }

    public Images setQuality(float quality) {
        this.quality = quality > 0.0f && quality < 1.0f ? quality : 1.0f;
        return this;
    }

    public Images setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Images scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        Image srcImg = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            double scaleDouble = MathKit.toDouble((Number)Float.valueOf(scale));
            this.targetImage = ImageKit.transform(AffineTransform.getScaleInstance(scaleDouble, scaleDouble), ImageKit.toBufferedImage(srcImg, this.targetImageType));
        } else {
            int width = MathKit.mul((Number[])new Number[]{srcImg.getWidth(null), Float.valueOf(scale)}).intValue();
            int height = MathKit.mul((Number[])new Number[]{srcImg.getHeight(null), Float.valueOf(scale)}).intValue();
            this.scale(width, height);
        }
        return this;
    }

    public Images scale(int width, int height) {
        return this.scale(width, height, 4);
    }

    public Images scale(int width, int height, int scaleType) {
        Image srcImg = this.getValidSrcImg();
        int srcHeight = srcImg.getHeight(null);
        int srcWidth = srcImg.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImg;
            return this;
        }
        if ("png".equals(this.targetImageType)) {
            double sx = MathKit.div((Number)width, (Number)srcWidth).doubleValue();
            double sy = MathKit.div((Number)height, (Number)srcHeight).doubleValue();
            this.targetImage = ImageKit.transform(AffineTransform.getScaleInstance(sx, sy), ImageKit.toBufferedImage(srcImg, this.targetImageType));
        } else {
            this.targetImage = srcImg.getScaledInstance(width, height, scaleType);
        }
        return this;
    }

    public Images scale(int width, int height, Color fixedColor) {
        Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = MathKit.div((Number)height, (Number)srcHeight).doubleValue();
        double widthRatio = MathKit.div((Number)width, (Number)srcWidth).doubleValue();
        if (MathKit.equals((Number)heightRatio, (Number)widthRatio)) {
            this.scale(width, height);
        } else if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        srcImage = this.getValidSrcImg();
        srcHeight = srcImage.getHeight(null);
        srcWidth = srcImage.getWidth(null);
        BufferedImage image = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D g = image.createGraphics();
        if (null != fixedColor) {
            g.setBackground(fixedColor);
            g.clearRect(0, 0, width, height);
        }
        g.drawImage(srcImage, (width - srcWidth) / 2, (height - srcHeight) / 2, srcWidth, srcHeight, fixedColor, null);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public Images cut(Rectangle rectangle) {
        Image srcImage = this.getValidSrcImg();
        this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.targetImage = ImageKit.filter(cropFilter, srcImage);
        return this;
    }

    public Images cut(int x, int y) {
        return this.cut(x, y, -1);
    }

    public Images cut(int x, int y, int radius) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        int diameter = radius > 0 ? radius * 2 : Math.min(width, height);
        BufferedImage targetImage = new BufferedImage(diameter, diameter, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setClip(new Ellipse2D.Double(0.0, 0.0, diameter, diameter));
        if (this.positionBaseCentre) {
            x = x - width / 2 + diameter / 2;
            y = y - height / 2 + diameter / 2;
        }
        g.drawImage(srcImage, x, y, null);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images round(double arc) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        arc = MathKit.mul((Number[])new Number[]{arc, Math.min(width, height)}).doubleValue();
        BufferedImage targetImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = targetImage.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(srcImage, 0, 0, null);
        g2.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images gray() {
        this.targetImage = ImageKit.colorConvert(ColorSpace.getInstance(1003), this.getValidSrcBufferedImg());
        return this;
    }

    public Images binary() {
        this.targetImage = ImageKit.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    public Images pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        return this.pressText(ImageText.of(pressText, color, font, new Point(x, y), alpha));
    }

    public Images pressText(ImageText imageText) {
        BufferedImage targetImage = ImageKit.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        Font font = imageText.getFont();
        if (null == font) {
            font = ImageKit.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        Graphics2D g = targetImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, imageText.getAlpha()));
        Point point = imageText.getPoint();
        if (this.positionBaseCentre) {
            ImageKit.drawString((Graphics)g, imageText.getPressText(), font, imageText.getColor(), new Rectangle(point.x, point.y, targetImage.getWidth(), targetImage.getHeight()));
        } else {
            ImageKit.drawString((Graphics)g, imageText.getPressText(), font, imageText.getColor(), point);
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images pressTextFull(String pressText, Color color, Font font, int lineHeight, int degree, float alpha) {
        Dimension dimension;
        BufferedImage targetImage = ImageKit.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        if (null == font) {
            font = ImageKit.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        int targetHeight = targetImage.getHeight();
        int targetWidth = targetImage.getWidth();
        Graphics2D g = targetImage.createGraphics();
        g.setColor(color);
        g.rotate(Math.toRadians(degree), targetWidth >> 1, targetHeight >> 1);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        try {
            dimension = ImageKit.getDimension(g.getFontMetrics(font), pressText);
        }
        catch (Exception e) {
            dimension = new Dimension(targetWidth / 3, targetHeight / 3);
        }
        int intervalHeight = dimension.height * lineHeight;
        int y = -targetHeight >> 1;
        while ((double)y < (double)targetHeight * 1.5) {
            int x = -targetWidth >> 1;
            while ((double)x < (double)targetWidth * 1.5) {
                ImageKit.drawString((Graphics)g, pressText, font, color, new Point(x, y));
                x += dimension.width;
            }
            y += intervalHeight;
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images pressImage(Image pressImg, int x, int y, float alpha) {
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        return this.pressImage(pressImg, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public Images pressImage(Image pressImg, Rectangle rectangle, float alpha) {
        Image targetImg = this.getValidSrcImg();
        this.targetImage = this.draw(ImageKit.toBufferedImage(targetImg, this.targetImageType), pressImg, rectangle, alpha);
        return this;
    }

    public Images pressImageFull(Image pressImage, int lineHeight, int degree, float alpha) {
        BufferedImage targetImage = ImageKit.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        int targetHeight = targetImage.getHeight();
        int targetWidth = targetImage.getWidth();
        Graphics2D g = targetImage.createGraphics();
        g.rotate(Math.toRadians(degree), targetWidth >> 1, targetHeight >> 1);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        int pressImageWidth = pressImage.getWidth(null);
        int pressImageHeight = pressImage.getHeight(null);
        Dimension dimension = new Dimension(pressImageWidth, pressImageHeight);
        int intervalHeight = dimension.height * lineHeight;
        int y = -targetHeight >> 1;
        while ((double)y < (double)targetHeight * 1.5) {
            int x = -targetWidth >> 1;
            while ((double)x < (double)targetWidth * 1.5) {
                ImageKit.drawImg((Graphics)g, pressImage, new Point(x, y));
                x += dimension.width;
            }
            y += intervalHeight;
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images rotate(int degree) {
        if (0 == degree) {
            return this;
        }
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = Images.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = ImageKit.createGraphics(targetImg, this.backgroundColor);
        graphics2d.setRenderingHints(RenderingHintsBuilder.of().setAntialiasing(RenderingHintsBuilder.Antialias.ON).setInterpolation(RenderingHintsBuilder.Interpolation.BILINEAR).build());
        graphics2d.translate((double)(rectangle.width - width) / 2.0, (double)(rectangle.height - height) / 2.0);
        graphics2d.rotate(Math.toRadians(degree), (double)width / 2.0, (double)height / 2.0);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Images flip() {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Images stroke(Color color, float width) {
        return this.stroke(color, new BasicStroke(width));
    }

    public Images stroke(Color color, Stroke stroke) {
        BufferedImage image = ImageKit.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        int width = image.getWidth();
        int height = image.getHeight();
        Graphics2D g = image.createGraphics();
        g.setColor((Color)ObjectKit.defaultIfNull((Object)color, (Object)Color.BLACK));
        if (null != stroke) {
            g.setStroke(stroke);
        }
        g.drawRect(0, 0, width - 1, height - 1);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public Image getImg() {
        return this.getValidSrcImg();
    }

    public Images write(OutputStream out) throws InternalException {
        this.write(ImageKit.getImageOutputStream(out));
        return this;
    }

    public Images write(ImageOutputStream targetImageStream) throws InternalException {
        Assert.notBlank((CharSequence)this.targetImageType, (String)"Target image type is blank !", (Object[])new Object[0]);
        Assert.notNull((Object)targetImageStream, (String)"Target output stream is null !", (Object[])new Object[0]);
        Image targetImage = null == this.targetImage ? this.srcImage : this.targetImage;
        Assert.notNull((Object)targetImage, (String)"Target image is null !", (Object[])new Object[0]);
        ImageKit.write(targetImage, this.targetImageType, targetImageStream, this.quality, this.backgroundColor);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Images write(File targetFile) throws InternalException {
        String formatName = FileName.extName((File)targetFile);
        if (StringKit.isNotBlank((CharSequence)formatName)) {
            this.targetImageType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ImageOutputStream out = null;
        try {
            out = ImageKit.getImageOutputStream(targetFile);
            this.write(out);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
            throw throwable;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        return this;
    }

    @Override
    public void flush() {
        ImageKit.flush(this.srcImage);
        ImageKit.flush(this.targetImage);
    }

    private BufferedImage draw(BufferedImage backgroundImg, Image img, Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        ImageKit.setAlpha(g, alpha);
        this.fixRectangle(rectangle, backgroundImg.getWidth(), backgroundImg.getHeight());
        ImageKit.drawImg((Graphics)g, img, rectangle);
        g.dispose();
        return backgroundImg;
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return (Image)ObjectKit.defaultIfNull((Object)this.targetImage, (Object)this.srcImage);
    }

    private BufferedImage getValidSrcBufferedImg() {
        return ImageKit.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
    }

    private Rectangle fixRectangle(Rectangle rectangle, int baseWidth, int baseHeight) {
        if (this.positionBaseCentre) {
            Point pointBaseCentre = ImageKit.getPointBaseCentre(rectangle, baseWidth, baseHeight);
            rectangle.setLocation(pointBaseCentre.x, pointBaseCentre.y);
        }
        return rectangle;
    }
}

