/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mail;

import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.mail.GlobalMailAccount;
import org.miaixz.bus.extra.mail.Mail;
import org.miaixz.bus.extra.mail.MailAccount;

public class MailKit {
    public static String sendText(String to, String subject, String content, File ... files) {
        return MailKit.send(to, subject, content, false, files);
    }

    public static String sendHtml(String to, String subject, String content, File ... files) {
        return MailKit.send(to, subject, content, true, files);
    }

    public static String send(String to, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(MailKit.splitAddress(to), subject, content, isHtml, files);
    }

    public static String send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(MailKit.splitAddress(to), MailKit.splitAddress(cc), MailKit.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static String sendText(Collection<String> tos, String subject, String content, File ... files) {
        return MailKit.send(tos, subject, content, false, files);
    }

    public static String sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        return MailKit.send(tos, subject, content, true, files);
    }

    public static String send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(tos, null, null, subject, content, isHtml, files);
    }

    public static String send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(GlobalMailAccount.INSTANCE.getAccount(), true, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(mailAccount, MailKit.splitAddress(to), subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(mailAccount, tos, null, null, subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        return MailKit.send(mailAccount, false, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static String sendHtml(String to, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        return MailKit.send(to, subject, content, imageMap, true, files);
    }

    public static String send(String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(MailKit.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static String send(String to, String cc, String bcc, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(MailKit.splitAddress(to), MailKit.splitAddress(cc), MailKit.splitAddress(bcc), subject, content, imageMap, isHtml, files);
    }

    public static String sendHtml(Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        return MailKit.send(tos, subject, content, imageMap, true, files);
    }

    public static String send(Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static String send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(GlobalMailAccount.INSTANCE.getAccount(), true, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(mailAccount, MailKit.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(mailAccount, tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailKit.send(mailAccount, false, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static Session getSession(final MailAccount mailAccount, boolean isSingleton) {
        Authenticator authenticator = null;
        if (mailAccount.isAuth().booleanValue()) {
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailAccount.getUser(), String.valueOf(mailAccount.getPass()));
                }
            };
        }
        return isSingleton ? Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), (Authenticator)authenticator) : Session.getInstance((Properties)mailAccount.getSmtpProps(), (Authenticator)authenticator);
    }

    private static String send(MailAccount mailAccount, boolean useGlobalSession, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        Mail mail = Mail.of(mailAccount).setUseGlobalSession(useGlobalSession);
        if (CollKit.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[0]));
        }
        if (CollKit.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[0]));
        }
        mail.setTos(tos.toArray(new String[0]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        if (MapKit.isNotEmpty(imageMap)) {
            for (Map.Entry<String, InputStream> entry : imageMap.entrySet()) {
                mail.addImage(entry.getKey(), entry.getValue());
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{entry.getValue()});
            }
        }
        return mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StringKit.isBlank((CharSequence)addresses)) {
            return null;
        }
        List result = StringKit.contains((CharSequence)addresses, (char)',') ? CharsBacker.splitTrim((CharSequence)addresses, (CharSequence)",") : (StringKit.contains((CharSequence)addresses, (char)';') ? CharsBacker.splitTrim((CharSequence)addresses, (CharSequence)";") : ListKit.of((Object[])new String[]{addresses}));
        return result;
    }
}

