/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.pinyin;

import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.loader.spi.ServiceLoader;
import org.miaixz.bus.core.xyz.SPIKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.pinyin.PinyinProvider;
import org.miaixz.bus.logger.Logger;

public class PinyinFactory {
    public static PinyinProvider get() {
        PinyinProvider engine = (PinyinProvider)Instances.get((String)PinyinProvider.class.getName(), PinyinFactory::create);
        Logger.debug((String)"Use [{}] Pinyin Provider As Default.", (Object[])new Object[]{StringKit.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    public static PinyinProvider create() {
        return PinyinFactory.doCreate();
    }

    public static PinyinProvider create(String name) throws InternalException {
        if (!StringKit.endWithIgnoreCase((CharSequence)name, (CharSequence)"Provider")) {
            name = (String)name + "Provider";
        }
        ServiceLoader list = SPIKit.loadList(PinyinProvider.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StringKit.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)name)) continue;
            return (PinyinProvider)list.getService(serviceName);
        }
        throw new InternalException("No such engine named: " + (String)name);
    }

    private static PinyinProvider doCreate() {
        PinyinProvider engine = (PinyinProvider)SPIKit.loadFirstAvailable(PinyinProvider.class);
        if (null != engine) {
            return engine;
        }
        throw new InternalException("No pinyin jar found !Please add one of it to your project !");
    }
}

