/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.Image;
import org.miaixz.bus.core.xyz.ColorKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.qrcode.QrConfig;

public class QrSVG {
    private final BitMatrix matrix;
    private final QrConfig qrConfig;

    public QrSVG(BitMatrix matrix, QrConfig qrConfig) {
        this.matrix = matrix;
        this.qrConfig = qrConfig;
    }

    public String toString() {
        Image logoImg = this.qrConfig.img;
        Integer foreColor = this.qrConfig.foreColor;
        Integer backColor = this.qrConfig.backColor;
        int ratio = this.qrConfig.ratio;
        StringBuilder sb = new StringBuilder();
        int qrWidth = this.matrix.getWidth();
        int qrHeight = this.matrix.getHeight();
        int moduleHeight = qrHeight == 1 ? qrWidth / 2 : 1;
        for (int y = 0; y < qrHeight; ++y) {
            for (int x = 0; x < qrWidth; ++x) {
                if (!this.matrix.get(x, y)) continue;
                sb.append(" M").append(x).append(",").append(y).append("h1v").append(moduleHeight).append("h-1z");
            }
        }
        qrHeight *= moduleHeight;
        String logoBase64 = "";
        int logoWidth = 0;
        int logoHeight = 0;
        int logoX = 0;
        int logoY = 0;
        if (logoImg != null) {
            logoBase64 = ImageKit.toBase64DataUri(logoImg, "png");
            if (qrWidth < qrHeight) {
                logoWidth = qrWidth / ratio;
                logoHeight = logoImg.getHeight(null) * logoWidth / logoImg.getWidth(null);
            } else {
                logoHeight = qrHeight / ratio;
                logoWidth = logoImg.getWidth(null) * logoHeight / logoImg.getHeight(null);
            }
            logoX = (qrWidth - logoWidth) / 2;
            logoY = (qrHeight - logoHeight) / 2;
        }
        StringBuilder result = StringKit.builder();
        result.append("<svg width=\"").append(qrWidth).append("\" height=\"").append(qrHeight).append("\" \n");
        if (backColor != null) {
            Color back = new Color(backColor, true);
            result.append("style=\"background-color:").append(ColorKit.toCssRgba((Color)back)).append("\"\n");
        }
        result.append("viewBox=\"0 0 ").append(qrWidth).append(" ").append(qrHeight).append("\" \n");
        result.append("xmlns=\"http://www.w3.org/2000/svg\" \n");
        result.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" >\n");
        result.append("<path d=\"").append((CharSequence)sb).append("\" ");
        if (foreColor != null) {
            Color fore = new Color(foreColor, true);
            result.append("stroke=\"").append(ColorKit.toCssRgba((Color)fore)).append("\"");
        }
        result.append(" /> \n");
        if (StringKit.isNotBlank((CharSequence)logoBase64)) {
            result.append("<image xlink:href=\"").append(logoBase64).append("\" height=\"").append(logoHeight).append("\" width=\"").append(logoWidth).append("\" y=\"").append(logoY).append("\" x=\"").append(logoX).append("\" />\n");
        }
        result.append("</svg>");
        return result.toString();
    }
}

