/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.compress.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardCopyOption;
import java.util.RandomAccess;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.compress.extractor.Extractor;
import org.miaixz.bus.extra.compress.extractor.Seven7EntryInputStream;

public class SevenZExtractor
implements Extractor,
RandomAccess {
    private final SevenZFile sevenZFile;

    public SevenZExtractor(File file) {
        this(file, null);
    }

    public SevenZExtractor(File file, char[] password) {
        try {
            this.sevenZFile = ((SevenZFile.Builder)SevenZFile.builder().setFile(file)).setPassword(password).get();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public SevenZExtractor(InputStream in) {
        this(in, null);
    }

    public SevenZExtractor(InputStream in, char[] password) {
        this((SeekableByteChannel)new SeekableInMemoryByteChannel(IoKit.readBytes((InputStream)in)), password);
    }

    public SevenZExtractor(SeekableByteChannel channel) {
        this(channel, null);
    }

    public SevenZExtractor(SeekableByteChannel channel, char[] password) {
        try {
            this.sevenZFile = SevenZFile.builder().setSeekableByteChannel(channel).setPassword(password).get();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void extract(File targetDir, Predicate<ArchiveEntry> predicate) {
        try {
            this.extractInternal(targetDir, predicate);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public InputStream getFirst(Predicate<ArchiveEntry> predicate) {
        SevenZFile sevenZFile = this.sevenZFile;
        for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
            if (null != predicate && !predicate.test((ArchiveEntry)entry) || entry.isDirectory()) continue;
            try {
                return sevenZFile.getInputStream(entry);
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return null;
    }

    private void extractInternal(File targetDir, Predicate<ArchiveEntry> predicate) throws IOException {
        SevenZArchiveEntry entry;
        Assert.isTrue((null != targetDir && (!targetDir.exists() || targetDir.isDirectory()) ? 1 : 0) != 0, (String)"target must be dir.", (Object[])new Object[0]);
        SevenZFile sevenZFile = this.sevenZFile;
        while (null != (entry = sevenZFile.getNextEntry())) {
            if (null != predicate && !predicate.test((ArchiveEntry)entry)) continue;
            File outItemFile = FileKit.file((File)targetDir, (String)entry.getName());
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            if (entry.hasStream()) {
                FileKit.copy((InputStream)new Seven7EntryInputStream(sevenZFile, entry), (File)outItemFile, (StandardCopyOption[])new StandardCopyOption[0]);
                continue;
            }
            FileKit.touch((File)outItemFile);
        }
    }

    @Override
    public void close() {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.sevenZFile});
    }
}

