/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mail;

import java.nio.charset.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.extra.mail.MailAccount;

public enum GlobalMailAccount {
    INSTANCE;

    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private static final String CHARSET = "mail.mime.charset";
    private final MailAccount mailAccount = this.createDefaultAccount();

    public MailAccount getAccount() {
        return this.mailAccount;
    }

    public void setSplitLongParams(boolean splitLongParams) {
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(splitLongParams));
    }

    public void setCharset(Charset charset) {
        System.setProperty(CHARSET, charset.name());
    }

    private MailAccount createDefaultAccount() {
        for (String mailSettingPath : MailAccount.MAIL_SETTING_PATHS) {
            try {
                return new MailAccount(mailSettingPath);
            }
            catch (InternalException internalException) {
            }
        }
        return null;
    }

    static {
        System.setProperty(SPLIT_LONG_PARAMS, "false");
        System.setProperty(CHARSET, GlobalMailAccount.INSTANCE.mailAccount.getCharset().name());
    }
}

