/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.pinyin.provider.jpinyin;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.extra.pinyin.PinyinProvider;

public class JPinyinProvider
implements PinyinProvider {
    private PinyinFormat format;

    public JPinyinProvider() {
        this(null);
    }

    public JPinyinProvider(PinyinFormat format) {
        this.init(format);
    }

    public void init(PinyinFormat format) {
        if (null == format) {
            format = PinyinFormat.WITHOUT_TONE;
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        Object[] results = PinyinHelper.convertToPinyinArray((char)c, (PinyinFormat)this.format);
        return ArrayKit.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
    }

    @Override
    public String getPinyin(String text, String separator) {
        try {
            return PinyinHelper.convertToPinyinString((String)text, (String)separator, (PinyinFormat)this.format);
        }
        catch (PinyinException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

