/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.DecodeHintType;
import com.google.zxing.common.BitMatrix;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.UrlKit;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.qrcode.QrAsciiArt;
import org.miaixz.bus.extra.qrcode.QrConfig;
import org.miaixz.bus.extra.qrcode.QrDecoder;
import org.miaixz.bus.extra.qrcode.QrEncoder;
import org.miaixz.bus.extra.qrcode.QrImage;
import org.miaixz.bus.extra.qrcode.QrSVG;

public class QrCodeKit {
    public static final String QR_TYPE_SVG = "svg";
    public static final String QR_TYPE_TXT = "txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateAsBase64DataUri(String content, QrConfig qrConfig, String imageType) {
        switch (imageType) {
            case "svg": {
                return QrCodeKit.svgToBase64DataUri(QrCodeKit.generateAsSvg(content, qrConfig));
            }
            case "txt": {
                return QrCodeKit.txtToBase64DataUri(QrCodeKit.generateAsAsciiArt(content, qrConfig));
            }
        }
        BufferedImage img = null;
        try {
            img = QrCodeKit.generate(content, qrConfig);
            String string = ImageKit.toBase64DataUri(img, imageType);
            return string;
        }
        finally {
            ImageKit.flush(img);
        }
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File destFile) {
        return QrCodeKit.generate(content, QrConfig.of(width, height), destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generate(String content, QrConfig config, File destFile) {
        String extName;
        switch (extName = FileName.extName((File)destFile)) {
            case "svg": {
                FileKit.writeUtf8String((String)QrCodeKit.generateAsSvg(content, config), (File)destFile);
                break;
            }
            case "txt": {
                FileKit.writeUtf8String((String)QrCodeKit.generateAsAsciiArt(content, config), (File)destFile);
                break;
            }
            default: {
                BufferedImage image = null;
                try {
                    image = QrCodeKit.generate(content, config);
                    ImageKit.write(image, destFile);
                    break;
                }
                finally {
                    ImageKit.flush(image);
                }
            }
        }
        return destFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        QrCodeKit.generate(content, QrConfig.of(width, height), imageType, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        switch (imageType) {
            case "svg": {
                IoKit.write((OutputStream)out, (boolean)false, (CharSequence[])new CharSequence[]{QrCodeKit.generateAsSvg(content, config)});
                break;
            }
            case "txt": {
                IoKit.write((OutputStream)out, (boolean)false, (CharSequence[])new CharSequence[]{QrCodeKit.generateAsAsciiArt(content, config)});
                break;
            }
            default: {
                BufferedImage img = null;
                try {
                    img = QrCodeKit.generate(content, config);
                    ImageKit.write((Image)img, imageType, out);
                    break;
                }
                finally {
                    ImageKit.flush(img);
                }
            }
        }
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeKit.generate(content, QrConfig.of(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return new QrImage(content, (QrConfig)ObjectKit.defaultIfNull((Object)config, QrConfig::new));
    }

    public static BitMatrix encode(CharSequence content, QrConfig config) {
        return QrEncoder.of(config).encode(content);
    }

    public static String decode(InputStream qrCodeInputstream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(qrCodeInputstream);
            String string = QrCodeKit.decode(image);
            return string;
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static String decode(File qrCodeFile) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(qrCodeFile);
            String string = QrCodeKit.decode(image);
            return string;
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static String decode(Image image) {
        return QrCodeKit.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrDecoder.of(isTryHarder, isPureBarcode).decode(image);
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        return QrDecoder.of(hints).decode(image);
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    public static String generateAsSvg(String content, QrConfig qrConfig) {
        return QrCodeKit.toSVG(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String toSVG(BitMatrix matrix, QrConfig config) {
        return new QrSVG(matrix, config).toString();
    }

    public static String generateAsAsciiArt(String content, QrConfig qrConfig) {
        return QrCodeKit.toAsciiArt(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String toAsciiArt(BitMatrix bitMatrix, QrConfig qrConfig) {
        return new QrAsciiArt(bitMatrix, qrConfig).toString();
    }

    private static String txtToBase64DataUri(String txt) {
        return UrlKit.getDataUriBase64((String)"text/plain", (String)Base64.encode((CharSequence)txt));
    }

    private static String svgToBase64DataUri(String svg) {
        return UrlKit.getDataUriBase64((String)"image/svg+xml", (String)Base64.encode((CharSequence)svg));
    }
}

