/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.codec.Decoder;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.qrcode.BufferedImageLuminanceSource;

public class QrDecoder
implements Decoder<Image, String> {
    private final Map<DecodeHintType, Object> hints;

    public QrDecoder(Map<DecodeHintType, Object> hints) {
        this.hints = hints;
    }

    public static QrDecoder of(boolean isTryHarder, boolean isPureBarcode) {
        return QrDecoder.of(QrDecoder.buildHints(isTryHarder, isPureBarcode));
    }

    public static QrDecoder of(Map<DecodeHintType, Object> hints) {
        return new QrDecoder(hints);
    }

    private static Result _decode(MultiFormatReader formatReader, Binarizer binarizer) {
        try {
            return formatReader.decodeWithState(new BinaryBitmap(binarizer));
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static Map<DecodeHintType, Object> buildHints(boolean isTryHarder, boolean isPureBarcode) {
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>(3, 1.0f);
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        if (isTryHarder) {
            hints.put(DecodeHintType.TRY_HARDER, true);
        }
        if (isPureBarcode) {
            hints.put(DecodeHintType.PURE_BARCODE, true);
        }
        return hints;
    }

    public String decode(Image image) {
        MultiFormatReader formatReader = new MultiFormatReader();
        formatReader.setHints(this.hints);
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(ImageKit.castToBufferedImage(image, "jpg"));
        Result result = QrDecoder._decode(formatReader, (Binarizer)new HybridBinarizer((LuminanceSource)source));
        if (null == result) {
            result = QrDecoder._decode(formatReader, (Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
        }
        return null != result ? result.getText() : null;
    }
}

