/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.miaixz.bus.extra.image.Images;
import org.miaixz.bus.extra.qrcode.QrCodeKit;
import org.miaixz.bus.extra.qrcode.QrConfig;

public class QrImage
extends BufferedImage {
    public QrImage(String content, QrConfig config) {
        this(QrCodeKit.encode(content, config), config);
    }

    public QrImage(BitMatrix matrix, QrConfig config) {
        super(matrix.getWidth(), matrix.getHeight(), null == config.backColor ? 2 : 1);
        this.init(matrix, config);
    }

    private void init(BitMatrix matrix, QrConfig config) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        Integer foreColor = config.foreColor;
        Integer backColor = config.backColor;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    this.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                this.setRGB(x, y, backColor);
            }
        }
        Image logoImg = config.img;
        if (null != logoImg && BarcodeFormat.QR_CODE == config.format) {
            int imgHeight;
            int imgWidth;
            int qrHeight;
            int qrWidth = this.getWidth();
            if (qrWidth < (qrHeight = this.getHeight())) {
                imgWidth = qrWidth / config.ratio;
                imgHeight = logoImg.getHeight(null) * imgWidth / logoImg.getWidth(null);
            } else {
                imgHeight = qrHeight / config.ratio;
                imgWidth = logoImg.getWidth(null) * imgHeight / logoImg.getHeight(null);
            }
            Images.from(this).pressImage(Images.from(logoImg).round(config.imgRound).getImg(), new Rectangle(imgWidth, imgHeight), 1.0f);
        }
    }
}

