/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.extra.ssh.Connector;
import org.miaixz.bus.extra.ssh.provider.jsch.ChannelType;

public class JschKit {
    public static Session openSession(Connector connector) {
        Session session;
        JSch jsch = new JSch();
        try {
            session = jsch.getSession(connector.getUser(), connector.getHost(), connector.getPort());
            session.setTimeout((int)connector.getTimeout());
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e);
        }
        session.setPassword(connector.getPassword());
        session.setConfig("StrictHostKeyChecking", "no");
        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        return session;
    }

    public static Channel openChannel(Session session, ChannelType channelType, long timeout) {
        Channel channel = JschKit.createChannel(session, channelType, timeout);
        try {
            channel.connect((int)Math.max(timeout, 0L));
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e);
        }
        return channel;
    }

    public static Channel createChannel(Session session, ChannelType channelType, long timeout) {
        Channel channel;
        try {
            if (!session.isConnected()) {
                session.connect((int)timeout);
            }
            channel = session.openChannel(channelType.getValue());
        }
        catch (JSchException e) {
            throw new InternalException((Throwable)e);
        }
        return channel;
    }

    public static void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static void close(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }
}

