/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh.provider.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.ssh.Connector;
import org.miaixz.bus.extra.ssh.MinaKit;
import org.miaixz.bus.extra.ssh.Session;

public class MinaSession
implements Session {
    private final SshClient sshClient = MinaKit.openClient();
    private final ClientSession raw;

    public MinaSession(Connector connector) {
        this.sshClient.setForwardingFilter((ForwardingFilter)new AcceptAllForwardingFilter());
        this.raw = MinaKit.openSession(this.sshClient, connector);
    }

    public Object getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && this.raw.isOpen();
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.raw});
        if (null != this.sshClient) {
            this.sshClient.stop();
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.sshClient});
    }

    @Override
    public void bindLocalPort(InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws InternalException {
        try {
            this.raw.startLocalPortForwarding(new SshdSocketAddress(localAddress), new SshdSocketAddress(remoteAddress));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void unBindLocalPort(InetSocketAddress localAddress) throws InternalException {
        try {
            this.raw.stopLocalPortForwarding(new SshdSocketAddress(localAddress));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void bindRemotePort(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws InternalException {
        try {
            this.raw.startRemotePortForwarding(new SshdSocketAddress(remoteAddress), new SshdSocketAddress(localAddress));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void unBindRemotePort(InetSocketAddress remoteAddress) throws InternalException {
        try {
            this.raw.stopRemotePortForwarding(new SshdSocketAddress(remoteAddress));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public String exec(String cmd, Charset charset) {
        return this.exec(cmd, charset, System.err);
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        try {
            return this.raw.executeRemoteCommand(cmd, errStream, charset);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        ChannelShell shellChannel;
        try {
            shellChannel = this.raw.createShellChannel();
            if (null != errStream) {
                shellChannel.setErr(errStream);
            }
            shellChannel.open().verify(new CancelOption[0]);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        IoKit.write((OutputStream)shellChannel.getInvertedIn(), (Charset)charset, (boolean)false, (CharSequence[])new CharSequence[]{cmd});
        return IoKit.read((InputStream)shellChannel.getInvertedOut(), (Charset)charset);
    }
}

