/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh.provider.sshj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.SocketForwardingConnectListener;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.ssh.Connector;
import org.miaixz.bus.extra.ssh.Session;
import org.miaixz.bus.extra.ssh.SshjKit;
import org.miaixz.bus.extra.ssh.provider.sshj.SshjSftp;

public class SshjSession
implements Session {
    private final SSHClient ssh;
    private final net.schmizz.sshj.connection.channel.direct.Session raw;
    private Map<String, ServerSocket> localPortForwarderMap;

    public SshjSession(Connector connector) {
        this(SshjKit.openClient(connector));
    }

    public SshjSession(SSHClient ssh) {
        this.ssh = ssh;
        try {
            this.raw = ssh.startSession();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public net.schmizz.sshj.connection.channel.direct.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && (null == this.ssh || this.ssh.isConnected());
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.raw});
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.ssh});
    }

    public SshjSftp openSftp(Charset charset) {
        return new SshjSftp(this.ssh, charset);
    }

    @Override
    public void bindLocalPort(InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws InternalException {
        ServerSocket ss;
        Parameters params = new Parameters(localAddress.getHostName(), localAddress.getPort(), remoteAddress.getHostName(), remoteAddress.getPort());
        try {
            ss = new ServerSocket();
            ss.setReuseAddress(true);
            ss.bind(localAddress);
            this.ssh.newLocalPortForwarder(params, ss).listen();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null == this.localPortForwarderMap) {
            this.localPortForwarderMap = new HashMap<String, ServerSocket>();
        }
        this.localPortForwarderMap.put(localAddress.toString(), ss);
    }

    @Override
    public void unBindLocalPort(InetSocketAddress localAddress) throws InternalException {
        if (MapKit.isEmpty(this.localPortForwarderMap)) {
            return;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.localPortForwarderMap.remove(localAddress.toString())});
    }

    @Override
    public void bindRemotePort(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws InternalException {
        try {
            this.ssh.getRemotePortForwarder().bind(new RemotePortForwarder.Forward(remoteAddress.getHostName(), remoteAddress.getPort()), (ConnectListener)new SocketForwardingConnectListener((SocketAddress)localAddress));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void unBindRemotePort(InetSocketAddress remoteAddress) {
        String hostName = remoteAddress.getHostName();
        int port = remoteAddress.getPort();
        RemotePortForwarder remotePortForwarder = this.ssh.getRemotePortForwarder();
        Set activeForwards = remotePortForwarder.getActiveForwards();
        for (RemotePortForwarder.Forward activeForward : activeForwards) {
            String activeAddress;
            if (port != activeForward.getPort() || StringKit.isNotBlank((CharSequence)(activeAddress = activeForward.getAddress())) && !StringKit.equalsIgnoreCase((CharSequence)hostName, (CharSequence)activeAddress)) continue;
            try {
                remotePortForwarder.cancel(activeForward);
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
            return;
        }
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        Session.Command command;
        if (null == charset) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        try {
            command = this.raw.exec(cmd);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (null != errStream) {
            IoKit.copy((InputStream)command.getErrorStream(), (OutputStream)errStream);
        }
        return IoKit.read((InputStream)command.getInputStream(), (Charset)charset);
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        Session.Shell shell;
        if (null == charset) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        try {
            shell = this.raw.startShell();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        IoKit.write((OutputStream)shell.getOutputStream(), (Charset)charset, (boolean)true, (CharSequence[])new CharSequence[]{cmd});
        if (null != errStream) {
            IoKit.copy((InputStream)shell.getErrorStream(), (OutputStream)errStream);
        }
        return IoKit.read((InputStream)shell.getInputStream(), (Charset)charset);
    }
}

