/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.captcha.strategy;

import org.miaixz.bus.core.math.Calculator;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.captcha.strategy.CodeStrategy;

public class MathStrategy
implements CodeStrategy {
    private static final long serialVersionUID = 2852292238303L;
    private static final String operators = "+-*";
    private final int numberLength;
    private final boolean resultHasNegativeNumber;

    public MathStrategy() {
        this(2, false);
    }

    public MathStrategy(int numberLength, boolean resultHasNegativeNumber) {
        this.numberLength = numberLength;
        this.resultHasNegativeNumber = resultHasNegativeNumber;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        char operator = RandomKit.randomChar((String)operators);
        int numberInt1 = RandomKit.randomInt((int)limit);
        int numberInt2 = !this.resultHasNegativeNumber && CharKit.equals((char)'-', (char)operator, (boolean)false) ? (numberInt1 == 0 ? 0 : RandomKit.randomInt((int)0, (int)numberInt1)) : RandomKit.randomInt((int)limit);
        String number1 = Integer.toString(numberInt1);
        String number2 = Integer.toString(numberInt2);
        number1 = StringKit.padAfter((CharSequence)number1, (int)this.numberLength, (char)' ');
        number2 = StringKit.padAfter((CharSequence)number2, (int)this.numberLength, (char)' ');
        return StringKit.builder().append(number1).append(operator).append(number2).append('=').toString();
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion((String)code);
        return result == calculateResult;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StringKit.repeat((char)'0', (int)this.numberLength));
    }
}

