/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.compress.archiver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.compress.archiver.Archiver;

public class StreamArchiver
implements Archiver {
    private final ArchiveOutputStream<? extends ArchiveEntry> out;

    public StreamArchiver(Charset charset, String archiverName, File file) {
        this(charset, archiverName, FileKit.getOutputStream((File)file, (OpenOption[])new OpenOption[0]));
    }

    public StreamArchiver(Charset charset, String archiverName, OutputStream targetStream) {
        if ("tgz".equalsIgnoreCase(archiverName) || "tar.gz".equalsIgnoreCase(archiverName)) {
            try {
                this.out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(targetStream));
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
        try {
            this.out = factory.createArchiveOutputStream(archiverName, targetStream);
        }
        catch (ArchiveException e) {
            throw new InternalException((Throwable)e);
        }
        if (this.out instanceof TarArchiveOutputStream) {
            ((TarArchiveOutputStream)this.out).setLongFileMode(2);
        } else if (this.out instanceof ArArchiveOutputStream) {
            ((ArArchiveOutputStream)this.out).setLongFileMode(1);
        }
    }

    public static StreamArchiver of(Charset charset, String archiverName, File file) {
        return new StreamArchiver(charset, archiverName, file);
    }

    public static StreamArchiver of(Charset charset, String archiverName, OutputStream out) {
        return new StreamArchiver(charset, archiverName, out);
    }

    @Override
    public StreamArchiver add(File file, String path, Function<String, String> fileNameEditor, Predicate<File> predicate) throws InternalException {
        try {
            this.addInternal(file, path, fileNameEditor, predicate);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public StreamArchiver finish() {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.out});
    }

    private void addInternal(File file, String path, Function<String, String> fileNameEditor, Predicate<File> predicate) throws IOException {
        Object entryName;
        if (null != predicate && !predicate.test(file)) {
            return;
        }
        ArchiveOutputStream<? extends ArchiveEntry> out = this.out;
        Object object = entryName = fileNameEditor == null ? file.getName() : fileNameEditor.apply(file.getName());
        if (StringKit.isNotEmpty((CharSequence)path)) {
            entryName = StringKit.addSuffixIfNot((CharSequence)path, (CharSequence)"/") + (String)entryName;
        }
        out.putArchiveEntry(out.createArchiveEntry(file, (String)entryName));
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ArrayKit.isNotEmpty((Object[])files)) {
                for (Object childFile : files) {
                    this.addInternal((File)childFile, (String)entryName, fileNameEditor, predicate);
                }
            } else {
                out.closeArchiveEntry();
            }
        } else {
            if (file.isFile()) {
                FileKit.copy((File)file, out);
            }
            out.closeArchiveEntry();
        }
    }
}

