/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.ftp.AbstractFtp;
import org.miaixz.bus.extra.ftp.FtpConfig;
import org.miaixz.bus.extra.ssh.Connector;

public class CommonsFtp
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private EnumValue.FtpMode mode;
    private boolean backToPwd;

    public CommonsFtp(FtpConfig config, EnumValue.FtpMode mode) {
        super(config);
        this.mode = mode;
        this.init();
    }

    public CommonsFtp(FTPClient client) {
        super(FtpConfig.of());
        this.client = client;
    }

    public static CommonsFtp of(String host) {
        return CommonsFtp.of(host, 21);
    }

    public static CommonsFtp of(String host, int port) {
        return CommonsFtp.of(host, port, "anonymous", "");
    }

    public static CommonsFtp of(String host, int port, String user, String password) {
        return CommonsFtp.of(Connector.of(host, port, user, password), DEFAULT_CHARSET);
    }

    public static CommonsFtp of(Connector connector, Charset charset) {
        return CommonsFtp.of(connector, charset, null, null);
    }

    public static CommonsFtp of(Connector connector, Charset charset, String serverLanguageCode, String systemKey) {
        return CommonsFtp.of(connector, charset, serverLanguageCode, systemKey, null);
    }

    public static CommonsFtp of(Connector connector, Charset charset, String serverLanguageCode, String systemKey, EnumValue.FtpMode mode) {
        return new CommonsFtp(new FtpConfig(connector, charset, serverLanguageCode, systemKey), mode);
    }

    public CommonsFtp init() {
        return this.init(this.ftpConfig, this.mode);
    }

    public CommonsFtp init(FtpConfig config, EnumValue.FtpMode mode) {
        FTPClient client = new FTPClient();
        client.setRemoteVerificationEnabled(false);
        Charset charset = config.getCharset();
        if (null != charset) {
            client.setControlEncoding(charset.toString());
        }
        client.setConnectTimeout((int)config.getConnector().getTimeout());
        String systemKey = config.getSystemKey();
        if (StringKit.isNotBlank((CharSequence)systemKey)) {
            FTPClientConfig conf = new FTPClientConfig(systemKey);
            String serverLanguageCode = config.getServerLanguageCode();
            if (StringKit.isNotBlank((CharSequence)serverLanguageCode)) {
                conf.setServerLanguageCode(config.getServerLanguageCode());
            }
            client.configure(conf);
        }
        Connector connector = config.getConnector();
        try {
            client.connect(connector.getHost(), connector.getPort());
            client.setSoTimeout((int)config.getSoTimeout());
            client.login(connector.getUser(), connector.getPassword());
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new InternalException("Login failed for user [{}], reply code is: [{}]", new Object[]{connector.getUser(), replyCode});
        }
        this.client = client;
        if (mode != null) {
            this.setMode(mode);
        }
        return this;
    }

    public CommonsFtp setMode(EnumValue.FtpMode mode) {
        this.mode = mode;
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    public boolean isBackToPwd() {
        return this.backToPwd;
    }

    public CommonsFtp setBackToPwd(boolean backToPwd) {
        this.backToPwd = backToPwd;
        return this;
    }

    @Override
    public CommonsFtp reconnectIfTimeout() {
        String pwd = null;
        try {
            pwd = this.pwd();
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        if (pwd == null) {
            return this.init();
        }
        return this;
    }

    @Override
    public synchronized boolean cd(String directory) {
        if (StringKit.isBlank((CharSequence)directory)) {
            return true;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return ArrayKit.mapToList((Object[])this.lsFiles(path), FTPFile::getName);
    }

    public List<String> ls(String path, Predicate<FTPFile> predicate) {
        return CollKit.map(this.lsFiles(path, predicate), FTPFile::getName);
    }

    public List<FTPFile> lsFiles(String path, Predicate<FTPFile> predicate) {
        Object[] ftpFiles = this.lsFiles(path);
        if (ArrayKit.isEmpty((Object[])ftpFiles)) {
            return ListKit.empty();
        }
        ArrayList<FTPFile> result = new ArrayList<FTPFile>(ftpFiles.length - 2 <= 0 ? ftpFiles.length : ftpFiles.length - 2);
        for (Object ftpFile : ftpFiles) {
            String fileName = ftpFile.getName();
            if (StringKit.equals((CharSequence)".", (CharSequence)fileName) || StringKit.equals((CharSequence)"..", (CharSequence)fileName) || null != predicate && !predicate.test((FTPFile)ftpFile)) continue;
            result.add((FTPFile)ftpFile);
        }
        return result;
    }

    public FTPFile[] lsFiles(String path) throws InternalException {
        FTPFile[] ftpFiles;
        String pwd = null;
        if (StringKit.isNotBlank((CharSequence)path)) {
            pwd = this.pwd();
            if (!this.cd(path)) {
                throw new InternalException("Change dir to [{}] error, maybe path not exist!", path);
            }
        }
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.cd(pwd);
        }
        return ftpFiles;
    }

    @Override
    public boolean rename(String oldPath, String newPath) {
        try {
            return this.client.rename(oldPath, newPath);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean mkdir(String dir) throws InternalException {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public int stat(String path) throws InternalException {
        try {
            return this.client.stat(path);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean existFile(String path) throws InternalException {
        Object[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return ArrayKit.isNotEmpty((Object[])ftpFileArr);
    }

    @Override
    public boolean delFile(String path) throws InternalException {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileName.getName((String)path);
        String dir = StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName);
        if (!this.cd(dir)) {
            throw new InternalException("Change dir to [{}] error, maybe dir not exist!", path);
        }
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.cd(pwd);
        }
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) throws InternalException {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StringKit.format((CharSequence)"{}/{}", (Object[])new Object[]{dirPath, name});
            if (ftpFile.isDirectory()) {
                if (".".equals(name) || "..".equals(name)) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean uploadFile(String remotePath, File file) {
        Assert.notNull((Object)file, (String)"file to upload is null !", (Object[])new Object[0]);
        if (!FileKit.isFile((File)file)) {
            throw new InternalException("[{}] is not a file!", new Object[]{file});
        }
        return this.uploadFile(remotePath, file.getName(), file);
    }

    public boolean uploadFile(String remotePath, String fileName, File file) throws InternalException {
        boolean bl;
        block8: {
            BufferedInputStream in = FileKit.getInputStream((File)file);
            try {
                bl = this.uploadFile(remotePath, fileName, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            ((InputStream)in).close();
        }
        return bl;
    }

    public boolean uploadFile(String remotePath, String fileName, InputStream fileStream) throws InternalException {
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (StringKit.isNotBlank((CharSequence)remotePath)) {
            this.mkDirs(remotePath);
            if (!this.cd(remotePath)) {
                throw new InternalException("Change dir to [{}] error, maybe dir not exist!", remotePath);
            }
        }
        try {
            boolean bl = this.client.storeFile(fileName, fileStream);
            return bl;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    public void upload(String remotePath, File uploadFile) {
        if (!FileKit.isDirectory((File)uploadFile)) {
            this.uploadFile(remotePath, uploadFile);
            return;
        }
        Object[] files = uploadFile.listFiles();
        if (ArrayKit.isEmpty((Object[])files)) {
            return;
        }
        ArrayList<Object> dirs = new ArrayList<Object>(files.length);
        for (Object f : files) {
            if (((File)f).isDirectory()) {
                dirs.add(f);
                continue;
            }
            this.uploadFile(remotePath, (File)f);
        }
        for (File file : dirs) {
            String dir = FileKit.normalize((String)(remotePath + "/" + file.getName()));
            this.upload(dir, file);
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileName.getName((String)path);
        String dir = StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.download(dir, fileName, outFile);
    }

    @Override
    public void recursiveDownloadFolder(String sourceDir, File targetDir) {
        for (FTPFile ftpFile : this.lsFiles(sourceDir, null)) {
            String fileName = ftpFile.getName();
            String srcFile = StringKit.format((CharSequence)"{}/{}", (Object[])new Object[]{sourceDir, fileName});
            File destFile = FileKit.file((File)targetDir, (String)fileName);
            if (!ftpFile.isDirectory()) {
                if (FileKit.exists((File)destFile) && ftpFile.getTimestamp().getTimeInMillis() <= destFile.lastModified()) continue;
                this.download(srcFile, destFile);
                continue;
            }
            FileKit.mkdir((File)destFile);
            this.recursiveDownloadFolder(srcFile, destFile);
        }
    }

    public boolean download(String path, String fileName, File outFile) throws InternalException {
        boolean bl;
        block10: {
            if (outFile.isDirectory()) {
                outFile = new File(outFile, fileName);
            }
            if (!outFile.exists()) {
                FileKit.touch((File)outFile);
            }
            BufferedOutputStream out = FileKit.getOutputStream((File)outFile, (OpenOption[])new OpenOption[0]);
            try {
                bl = this.download(path, fileName, out);
                if (out == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            ((OutputStream)out).close();
        }
        return bl;
    }

    public boolean download(String path, String fileName, OutputStream out) {
        return this.download(path, fileName, out, null);
    }

    public boolean download(String path, String fileName, OutputStream out, Charset fileNameCharset) throws InternalException {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (!this.cd(path)) {
            throw new InternalException("Change dir to [{}] error, maybe dir not exist!", path);
        }
        if (null != fileNameCharset) {
            fileName = new String(fileName.getBytes(fileNameCharset), StandardCharsets.ISO_8859_1);
        }
        try {
            this.client.setFileType(2);
            boolean bl = this.client.retrieveFile(fileName, out);
            return bl;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public InputStream getFileStream(String path) {
        String fileName = FileName.getName((String)path);
        String dir = StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName);
        return this.getFileStream(dir, fileName);
    }

    public InputStream getFileStream(String dir, String fileName) throws InternalException {
        String pwd = null;
        if (this.isBackToPwd()) {
            pwd = this.pwd();
        }
        if (!this.cd(dir)) {
            throw new InternalException("Change dir to [{}] error, maybe dir not exist!", dir);
        }
        try {
            this.client.setFileType(2);
            InputStream inputStream = this.client.retrieveFileStream(fileName);
            return inputStream;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            if (this.isBackToPwd()) {
                this.cd(pwd);
            }
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

