/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.image;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.image.ImageKit;

public class ImageWriter
implements Flushable {
    private final RenderedImage image;
    private final javax.imageio.ImageWriter writer;
    private ImageWriteParam writeParam;

    public ImageWriter(Image image, String imageType) {
        this.image = ImageKit.castToRenderedImage(image, imageType);
        this.writer = ImageKit.getWriter(image, imageType);
    }

    public static ImageWriter of(Image image, String imageType, Color backgroundColor) {
        return ImageWriter.of(ImageKit.toBufferedImage(image, imageType, backgroundColor), imageType);
    }

    public static ImageWriter of(Image image, String imageType) {
        return new ImageWriter(image, imageType);
    }

    private static ImageWriteParam buildParam(RenderedImage renderedImage, javax.imageio.ImageWriter writer, float quality) {
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        return imgWriteParams;
    }

    public ImageWriter setQuality(float quality) {
        this.writeParam = ImageWriter.buildParam(this.image, this.writer, quality);
        return this;
    }

    public void write(OutputStream out) throws InternalException {
        this.write(ImageKit.getImageOutputStream(out));
    }

    public void write(File destFile) throws InternalException {
        FileKit.touch((File)destFile);
        ImageOutputStream out = null;
        try {
            out = ImageKit.getImageOutputStream(destFile);
            this.write(out);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
            throw throwable;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
    }

    public void write(ImageOutputStream output) {
        Assert.notNull((Object)output);
        javax.imageio.ImageWriter writer = this.writer;
        RenderedImage image = this.image;
        writer.setOutput(output);
        try {
            if (null != this.writeParam) {
                writer.write(null, new IIOImage(image, null, null), this.writeParam);
            } else {
                writer.write(image);
            }
            output.flush();
            writer.dispose();
        }
        catch (IOException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                writer.dispose();
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{output});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{output});
    }

    @Override
    public void flush() {
        RenderedImage renderedImage = this.image;
        if (renderedImage instanceof BufferedImage) {
            ImageKit.flush((BufferedImage)renderedImage);
        } else if (renderedImage instanceof Image) {
            ImageKit.flush((Image)((Object)renderedImage));
        }
    }
}

