/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.json.provider;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.extra.json.provider.AbstractJsonProvider;

public class FastJsonProvider
extends AbstractJsonProvider {
    private static final JSONWriter.Feature[] WRITER_FEATURES = new JSONWriter.Feature[]{JSONWriter.Feature.FieldBased, JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNulls};
    private static final Filter[] FILTERS = new Filter[]{(object, name, value) -> value == null || "".equals(value) || " ".equals(value) ? null : value};

    @Override
    public String toJsonString(Object object) {
        return JSON.toJSONString((Object)object, (Filter[])FILTERS, (JSONWriter.Feature[])WRITER_FEATURES);
    }

    @Override
    public String toJsonString(Object object, String format) {
        return JSON.toJSONString((Object)object, (String)format, (Filter[])FILTERS, (JSONWriter.Feature[])WRITER_FEATURES);
    }

    @Override
    public <T> T toPojo(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    @Override
    public <T> T toPojo(Map map, Class<T> clazz) {
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)map), clazz);
    }

    @Override
    public <T> List<T> toList(String json) {
        return (List)JSON.parseObject((String)json, LinkedList.class);
    }

    @Override
    public <T> List<T> toList(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    @Override
    public <T> List<T> toList(String json, Type type) {
        return (List)JSON.parseObject((String)json, (Type)type);
    }

    @Override
    public <K, V> Map<K, V> toMap(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    @Override
    public <K, V> Map<K, V> toMap(Object object) {
        return this.toMap(JSON.toJSONString((Object)object));
    }

    @Override
    public <T> T getValue(String json, String field) {
        return (T)JSON.parseObject((String)json).get(field);
    }

    @Override
    public boolean isJson(String json) {
        try {
            JSON.parseObject((String)json);
        }
        catch (RuntimeException ex) {
            try {
                JSON.parseArray((String)json);
            }
            catch (RuntimeException ex1) {
                return false;
            }
        }
        return true;
    }
}

