/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.FileTypeMap;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.miaixz.bus.core.Builder;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.mail.GlobalMailAccount;
import org.miaixz.bus.extra.mail.InternalMail;
import org.miaixz.bus.extra.mail.MailAccount;
import org.miaixz.bus.extra.mail.MailKit;

public class Mail
implements Builder<MimeMessage> {
    private static final long serialVersionUID = 2852285516881L;
    private final MailAccount mailAccount;
    private final Multipart multipart = new MimeMultipart();
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String[] reply;
    private String title;
    private String content;
    private boolean isHtml;
    private boolean useGlobalSession = false;
    private PrintStream debugOutput;

    public Mail() {
        this(GlobalMailAccount.INSTANCE.getAccount());
    }

    public Mail(MailAccount mailAccount) {
        mailAccount = null != mailAccount ? mailAccount : GlobalMailAccount.INSTANCE.getAccount();
        this.mailAccount = mailAccount.defaultIfEmpty();
    }

    public static Mail of(MailAccount mailAccount) {
        return new Mail(mailAccount);
    }

    public static Mail of() {
        return new Mail();
    }

    public Mail to(String ... tos) {
        return this.setTos(tos);
    }

    public Mail setTos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail setCcs(String ... ccs) {
        this.ccs = ccs;
        return this;
    }

    public Mail setBccs(String ... bccs) {
        this.bccs = bccs;
        return this;
    }

    public Mail setReply(String ... reply) {
        this.reply = reply;
        return this;
    }

    public Mail setTitle(String title) {
        this.title = title;
        return this;
    }

    public Mail setContent(String content) {
        this.content = content;
        return this;
    }

    public Mail setHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail setContent(String content, boolean isHtml) {
        this.setContent(content);
        return this.setHtml(isHtml);
    }

    public Mail setFiles(File ... files) {
        if (ArrayKit.isEmpty((Object[])files)) {
            return this;
        }
        DataSource[] attachments = new DataSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            attachments[i] = new FileDataSource(files[i]);
        }
        return this.setAttachments(attachments);
    }

    public Mail addImage(String cid, InputStream imageStream) {
        return this.addImage(cid, imageStream, null);
    }

    public Mail addImage(String cid, InputStream imageStream, String contentType) {
        ByteArrayDataSource imgSource;
        try {
            imgSource = new ByteArrayDataSource(imageStream, (String)ObjectKit.defaultIfNull((Object)contentType, (Object)"image/jpeg"));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        imgSource.setName(cid);
        return this.setAttachments(new DataSource[]{imgSource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mail addImage(String cid, File imageFile) {
        Mail mail;
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream((File)imageFile);
            mail = this.addImage(cid, in, FileTypeMap.getDefaultFileTypeMap().getContentType(imageFile));
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return mail;
    }

    public Mail setAttachments(DataSource ... attachments) {
        if (ArrayKit.isNotEmpty((Object[])attachments)) {
            Charset charset = this.mailAccount.getCharset();
            try {
                for (DataSource attachment : attachments) {
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler(attachment));
                    String nameEncoded = attachment.getName();
                    if (this.mailAccount.isEncodefilename()) {
                        nameEncoded = InternalMail.encodeText(nameEncoded, charset);
                    }
                    bodyPart.setFileName(nameEncoded);
                    if (StringKit.startWith((CharSequence)attachment.getContentType(), (CharSequence)"image/")) {
                        bodyPart.setContentID(nameEncoded);
                        bodyPart.setDisposition("inline");
                    }
                    this.multipart.addBodyPart((BodyPart)bodyPart);
                }
            }
            catch (MessagingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return this;
    }

    public Mail setCharset(Charset charset) {
        this.mailAccount.setCharset(charset);
        return this;
    }

    public Mail setUseGlobalSession(boolean isUseGlobalSession) {
        this.useGlobalSession = isUseGlobalSession;
        return this;
    }

    public Mail setDebugOutput(PrintStream debugOutput) {
        this.debugOutput = debugOutput;
        return this;
    }

    public MimeMessage build() {
        try {
            return this.buildMsg();
        }
        catch (MessagingException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public String send() throws InternalException {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            if (e instanceof SendFailedException) {
                Address[] invalidAddresses = ((SendFailedException)e).getInvalidAddresses();
                String msg = StringKit.format((CharSequence)"Invalid Addresses: {}", (Object[])new Object[]{ArrayKit.toString((Object)invalidAddresses)});
                throw new InternalException(msg, (Throwable)e);
            }
            throw new InternalException((Throwable)e);
        }
    }

    private String doSend() throws MessagingException {
        MimeMessage mimeMessage = this.buildMsg();
        Transport.send((Message)mimeMessage);
        return mimeMessage.getMessageID();
    }

    private MimeMessage buildMsg() throws MessagingException {
        Charset charset = this.mailAccount.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession());
        String from = this.mailAccount.getFrom();
        if (StringKit.isEmpty((CharSequence)from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)InternalMail.parseFirstAddress(from, charset));
        }
        msg.setSubject(this.title, null == charset ? null : charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent(charset));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMail.parseAddressFromStrs(this.tos, charset));
        if (ArrayKit.isNotEmpty((Object[])this.ccs)) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMail.parseAddressFromStrs(this.ccs, charset));
        }
        if (ArrayKit.isNotEmpty((Object[])this.bccs)) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMail.parseAddressFromStrs(this.bccs, charset));
        }
        if (ArrayKit.isNotEmpty((Object[])this.reply)) {
            msg.setReplyTo((Address[])InternalMail.parseAddressFromStrs(this.reply, charset));
        }
        return msg;
    }

    private Multipart buildContent(Charset charset) throws MessagingException {
        String charsetStr = null != charset ? charset.name() : MimeUtility.getDefaultJavaCharset();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, StringKit.format((CharSequence)"text/{}; charset={}", (Object[])new Object[]{this.isHtml ? "html" : "plain", charsetStr}));
        this.multipart.addBodyPart((BodyPart)body);
        return this.multipart;
    }

    private Session getSession() {
        Session session = MailKit.getSession(this.mailAccount, this.useGlobalSession);
        if (null != this.debugOutput) {
            session.setDebugOut(this.debugOutput);
        }
        return session;
    }
}

