/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.TextMessage;
import java.io.IOException;
import org.miaixz.bus.core.lang.exception.MQueueException;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.mq.Consumer;
import org.miaixz.bus.extra.mq.Message;
import org.miaixz.bus.extra.mq.MessageHandler;

public class JmsConsumer
implements Consumer {
    private String consumerGroup;
    private final MessageConsumer consumer;

    public JmsConsumer(String consumerGroup, MessageConsumer consumer) {
        this.consumerGroup = consumerGroup;
        this.consumer = consumer;
    }

    public JmsConsumer setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public void subscribe(MessageHandler messageHandler) {
        try {
            this.consumer.setMessageListener(message -> messageHandler.handle(new Message(){

                @Override
                public String topic() {
                    return JmsConsumer.this.consumerGroup;
                }

                @Override
                public byte[] content() {
                    try {
                        if (message instanceof TextMessage) {
                            return ByteKit.toBytes((CharSequence)((TextMessage)message).getText());
                        }
                        if (message instanceof BytesMessage) {
                            byte[] bytes = new byte[(int)((BytesMessage)message).getBodyLength()];
                            ((BytesMessage)message).readBytes(bytes);
                            return bytes;
                        }
                        throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
                    }
                    catch (JMSException e) {
                        throw new MQueueException((Throwable)e);
                    }
                }
            }));
        }
        catch (JMSException e) {
            throw new MQueueException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.consumer});
    }
}

