/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.IOException;
import org.miaixz.bus.core.lang.exception.MQueueException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.mq.Message;
import org.miaixz.bus.extra.mq.Producer;

public class JmsProducer
implements Producer {
    private final Session session;
    private final MessageProducer producer;

    public JmsProducer(Session session, MessageProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    @Override
    public void send(Message message) {
        try {
            BytesMessage bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(message.content());
            this.producer.send((jakarta.jms.Message)bytesMessage);
        }
        catch (JMSException e) {
            throw new MQueueException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.producer});
    }
}

