/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.Closeable;
import java.io.IOException;
import org.miaixz.bus.core.lang.exception.MQueueException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.mq.Consumer;
import org.miaixz.bus.extra.mq.MQConfig;
import org.miaixz.bus.extra.mq.MQProvider;
import org.miaixz.bus.extra.mq.Producer;
import org.miaixz.bus.extra.mq.provider.jms.JmsConsumer;
import org.miaixz.bus.extra.mq.provider.jms.JmsProducer;

public abstract class JmsProvider
implements MQProvider,
Closeable {
    private Connection connection;
    private Session session;
    private boolean isTopic;
    private String producerGroup = "hutool.queue";
    private String consumerGroup = "hutool.queue";

    @Override
    public MQProvider init(MQConfig config) {
        try {
            this.connection = this.createConnectionFactory(config).createConnection();
            this.session = this.connection.createSession();
        }
        catch (JMSException e) {
            throw new MQueueException((Throwable)e);
        }
        return this;
    }

    protected abstract ConnectionFactory createConnectionFactory(MQConfig var1);

    public JmsProvider setTopic(boolean isTopic) {
        this.isTopic = isTopic;
        return this;
    }

    public JmsProvider setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
        return this;
    }

    public JmsProvider setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public Producer getProducer() {
        MessageProducer messageProducer;
        try {
            messageProducer = this.session.createProducer(this.createDestination(this.producerGroup));
        }
        catch (JMSException e) {
            throw new MQueueException((Throwable)e);
        }
        return new JmsProducer(this.session, messageProducer);
    }

    @Override
    public Consumer getConsumer() {
        MessageConsumer messageConsumer;
        try {
            messageConsumer = this.session.createConsumer(this.createDestination(this.consumerGroup));
        }
        catch (JMSException e) {
            throw new MQueueException((Throwable)e);
        }
        return new JmsConsumer(this.consumerGroup, messageConsumer);
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.session});
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.connection});
    }

    private Destination createDestination(String group) {
        try {
            return this.isTopic ? this.session.createTopic(group) : this.session.createQueue(group);
        }
        catch (JMSException e) {
            throw new MQueueException((Throwable)e);
        }
    }
}

