/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.CommonClientConfigs;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.extra.mq.Consumer;
import org.miaixz.bus.extra.mq.MQConfig;
import org.miaixz.bus.extra.mq.MQProvider;
import org.miaixz.bus.extra.mq.Producer;
import org.miaixz.bus.extra.mq.provider.kafka.KafkaConsumer;
import org.miaixz.bus.extra.mq.provider.kafka.KafkaProducer;

public class KafkaProvider
implements MQProvider {
    private Properties properties;

    public KafkaProvider() {
        Assert.notNull(CommonClientConfigs.class);
    }

    public KafkaProvider(MQConfig config) {
        this.init(config);
    }

    public KafkaProvider(Properties properties) {
        this.init(properties);
    }

    @Override
    public KafkaProvider init(MQConfig config) {
        return this.init(KafkaProvider.buidProperties(config));
    }

    public KafkaProvider init(Properties properties) {
        this.properties = properties;
        return this;
    }

    public KafkaProvider addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public Producer getProducer() {
        return new KafkaProducer(this.properties);
    }

    @Override
    public Consumer getConsumer() {
        return new KafkaConsumer(this.properties);
    }

    private static Properties buidProperties(MQConfig config) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", config.getBrokerUrl());
        properties.putAll((Map<?, ?>)config.getProperties());
        return properties;
    }
}

