/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.miaixz.bus.core.lang.exception.MQueueException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.mq.Message;
import org.miaixz.bus.extra.mq.Producer;

public class RabbitMQProducer
implements Producer {
    private final Channel channel;
    private String exchange = "";

    public RabbitMQProducer(Channel channel) {
        this.channel = channel;
    }

    public RabbitMQProducer setExchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    public RabbitMQProducer queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        try {
            this.channel.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
        }
        catch (IOException e) {
            throw new MQueueException((Throwable)e);
        }
        return this;
    }

    @Override
    public void send(Message message) {
        try {
            this.channel.basicPublish(this.exchange, message.topic(), null, message.content());
        }
        catch (IOException e) {
            throw new MQueueException((Throwable)e);
        }
    }

    @Override
    public void close() {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.channel});
    }
}

