/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.MQueueException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.extra.mq.Consumer;
import org.miaixz.bus.extra.mq.MQConfig;
import org.miaixz.bus.extra.mq.MQProvider;
import org.miaixz.bus.extra.mq.Producer;
import org.miaixz.bus.extra.mq.provider.rabbitmq.RabbitMQConsumer;
import org.miaixz.bus.extra.mq.provider.rabbitmq.RabbitMQProducer;

public class RabbitMQProvider
implements MQProvider,
Closeable {
    private Connection connection;

    public RabbitMQProvider() {
        Assert.notNull(Connection.class);
    }

    public RabbitMQProvider(MQConfig config) {
        this.init(config);
    }

    public RabbitMQProvider(ConnectionFactory factory) {
        this.init(factory);
    }

    @Override
    public RabbitMQProvider init(MQConfig config) {
        return this.init(RabbitMQProvider.createFactory(config));
    }

    public RabbitMQProvider init(ConnectionFactory factory) {
        try {
            this.connection = factory.newConnection();
        }
        catch (IOException | TimeoutException e) {
            throw new MQueueException((Throwable)e);
        }
        return this;
    }

    @Override
    public Producer getProducer() {
        return new RabbitMQProducer(this.createChannel());
    }

    @Override
    public Consumer getConsumer() {
        return new RabbitMQConsumer(this.createChannel());
    }

    @Override
    public void close() throws IOException {
        IoKit.nullSafeClose((Closeable)this.connection);
    }

    private Channel createChannel() {
        try {
            return this.connection.createChannel();
        }
        catch (IOException e) {
            throw new MQueueException((Throwable)e);
        }
    }

    private static ConnectionFactory createFactory(MQConfig config) {
        ConnectionFactory factory = new ConnectionFactory();
        try {
            factory.setUri(config.getBrokerUrl());
        }
        catch (Exception e) {
            throw new MQueueException((Throwable)e);
        }
        return factory;
    }
}

