/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.mq.provider.rocketmq;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.MQueueException;
import org.miaixz.bus.extra.mq.Consumer;
import org.miaixz.bus.extra.mq.MQConfig;
import org.miaixz.bus.extra.mq.MQProvider;
import org.miaixz.bus.extra.mq.Producer;
import org.miaixz.bus.extra.mq.provider.rocketmq.RocketMQConsumer;
import org.miaixz.bus.extra.mq.provider.rocketmq.RocketMQProducer;

public class RocketMQProvider
implements MQProvider {
    private MQConfig config;
    private String producerGroup;
    private String consumerGroup;

    public RocketMQProvider() {
        Assert.notNull(Message.class);
        this.producerGroup = "DEFAULT_PRODUCER";
        this.consumerGroup = "DEFAULT_CONSUMER";
    }

    public RocketMQProvider setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
        return this;
    }

    public RocketMQProvider setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public RocketMQProvider init(MQConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public Producer getProducer() {
        DefaultMQProducer defaultMQProducer = new DefaultMQProducer(this.producerGroup);
        defaultMQProducer.setNamesrvAddr(this.config.getBrokerUrl());
        try {
            defaultMQProducer.start();
        }
        catch (MQClientException e) {
            throw new MQueueException((Throwable)e);
        }
        return new RocketMQProducer((MQProducer)defaultMQProducer);
    }

    @Override
    public Consumer getConsumer() {
        DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer(this.consumerGroup);
        defaultMQPushConsumer.setNamesrvAddr(this.config.getBrokerUrl());
        return new RocketMQConsumer((MQPushConsumer)defaultMQPushConsumer);
    }
}

