/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.nlp;

import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.loader.spi.NormalSpiLoader;
import org.miaixz.bus.core.lang.loader.spi.ServiceLoader;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.nlp.NLPProvider;
import org.miaixz.bus.logger.Logger;

public class NLPFactory {
    public static NLPProvider getEngine() {
        NLPProvider engine = (NLPProvider)Instances.get((String)NLPProvider.class.getName(), NLPFactory::createEngine);
        Logger.debug((String)"Use [{}] Tokenizer Engine As Default.", (Object[])new Object[]{StringKit.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    public static NLPProvider createEngine() {
        return NLPFactory.doCreateEngine();
    }

    public static NLPProvider createEngine(String engineName) throws InternalException {
        if (!StringKit.endWithIgnoreCase((CharSequence)engineName, (CharSequence)"Engine")) {
            engineName = (String)engineName + "Engine";
        }
        ServiceLoader list = NormalSpiLoader.loadList(NLPProvider.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StringKit.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)engineName)) continue;
            return (NLPProvider)list.getService(serviceName);
        }
        throw new InternalException("No such provider named: " + (String)engineName);
    }

    private static NLPProvider doCreateEngine() {
        NLPProvider engine = (NLPProvider)NormalSpiLoader.loadFirstAvailable(NLPProvider.class);
        if (null != engine) {
            return engine;
        }
        throw new InternalException("No tokenizer found !Please add some tokenizer jar to your project !");
    }
}

