/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.pinyin.provider.pinyin4j;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.logging.log4j.util.InternalException;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.extra.pinyin.PinyinProvider;

public class Pinyin4JProvider
implements PinyinProvider {
    private static final HanyuPinyinOutputFormat WITH_TONE_MARK = new HanyuPinyinOutputFormat();
    private static final HanyuPinyinOutputFormat WITHOUT_TONE;

    public Pinyin4JProvider() {
        Assert.notNull(PinyinHelper.class);
    }

    @Override
    public String getPinyin(char c, boolean tone) {
        Object result;
        try {
            Object[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)(tone ? WITH_TONE_MARK : WITHOUT_TONE));
            result = ArrayKit.isEmpty((Object[])results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            result = String.valueOf(c);
        }
        return result;
    }

    @Override
    public String getPinyin(String str, String separator, boolean tone) {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        int strLen = str.length();
        try {
            for (int i = 0; i < strLen; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append(separator);
                }
                Object[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i), (HanyuPinyinOutputFormat)(tone ? WITH_TONE_MARK : WITHOUT_TONE));
                if (ArrayKit.isEmpty((Object[])pinyinStringArray)) {
                    result.append(str.charAt(i));
                    continue;
                }
                result.append((String)pinyinStringArray[0]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new InternalException((Throwable)e);
        }
        return result.toString();
    }

    static {
        WITH_TONE_MARK.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        WITH_TONE_MARK.setVCharType(HanyuPinyinVCharType.WITH_V);
        WITH_TONE_MARK.setToneType(HanyuPinyinToneType.WITH_TONE_MARK);
        WITHOUT_TONE = new HanyuPinyinOutputFormat();
        WITHOUT_TONE.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        WITHOUT_TONE.setVCharType(HanyuPinyinVCharType.WITH_V);
        WITHOUT_TONE.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

