/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.DecodeHintType;
import com.google.zxing.common.BitMatrix;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.util.Map;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.UrlKit;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.qrcode.QrConfig;
import org.miaixz.bus.extra.qrcode.QrDecoder;
import org.miaixz.bus.extra.qrcode.QrEncoder;
import org.miaixz.bus.extra.qrcode.render.AsciiArtRender;
import org.miaixz.bus.extra.qrcode.render.ImageRender;
import org.miaixz.bus.extra.qrcode.render.SVGRender;

public class QrCodeKit {
    public static final String QR_TYPE_SVG = "svg";
    public static final String QR_TYPE_TXT = "txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateAsBase64DataUri(String content, QrConfig qrConfig, String imageType) {
        switch (imageType) {
            case "svg": {
                return QrCodeKit.svgToBase64DataUri(QrCodeKit.generateAsSvg(content, qrConfig));
            }
            case "txt": {
                return QrCodeKit.txtToBase64DataUri(QrCodeKit.generateAsAsciiArt(content, qrConfig));
            }
        }
        BufferedImage img = null;
        try {
            img = QrCodeKit.generate(content, qrConfig);
            String string = ImageKit.toBase64DataUri(img, imageType);
            return string;
        }
        finally {
            ImageKit.flush(img);
        }
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) {
        return QrCodeKit.generate(content, QrConfig.of(width, height), targetFile);
    }

    public static File generate(String content, QrConfig config, File targetFile) {
        String extName = FileName.extName((File)targetFile);
        try (BufferedOutputStream outputStream = FileKit.getOutputStream((File)targetFile, (OpenOption[])new OpenOption[0]);){
            QrCodeKit.generate(content, config, extName, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        QrCodeKit.generate(content, QrConfig.of(width, height), imageType, out);
    }

    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        (switch (imageType) {
            case QR_TYPE_SVG -> new SVGRender(config);
            case QR_TYPE_TXT -> new AsciiArtRender(config);
            default -> new ImageRender(config, imageType);
        }).render(QrCodeKit.encode(content, config), out);
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeKit.generate(content, QrConfig.of(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return new ImageRender((QrConfig)ObjectKit.defaultIfNull((Object)config, QrConfig::new), null).render(QrCodeKit.encode(content, config));
    }

    public static BitMatrix encode(CharSequence content, QrConfig config) {
        return QrEncoder.of(config).encode(content);
    }

    public static String decode(InputStream qrCodeInputstream) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(qrCodeInputstream);
            String string = QrCodeKit.decode(image);
            return string;
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static String decode(File qrCodeFile) {
        BufferedImage image = null;
        try {
            image = ImageKit.read(qrCodeFile);
            String string = QrCodeKit.decode(image);
            return string;
        }
        finally {
            ImageKit.flush(image);
        }
    }

    public static String decode(Image image) {
        return QrCodeKit.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrDecoder.of(isTryHarder, isPureBarcode).decode(image);
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        return QrDecoder.of(hints).decode(image);
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    public static String generateAsSvg(String content, QrConfig qrConfig) {
        return QrCodeKit.toSVG(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String toSVG(BitMatrix matrix, QrConfig config) {
        StringBuilder result = new StringBuilder();
        new SVGRender(config).render(matrix, result);
        return result.toString();
    }

    public static String generateAsAsciiArt(String content, QrConfig qrConfig) {
        return QrCodeKit.toAsciiArt(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String toAsciiArt(BitMatrix matrix, QrConfig config) {
        StringBuilder result = new StringBuilder();
        new AsciiArtRender(config).render(matrix, result);
        return result.toString();
    }

    private static String txtToBase64DataUri(String txt) {
        return UrlKit.getDataUriBase64((String)"text/plain", (String)Base64.encode((CharSequence)txt));
    }

    private static String svgToBase64DataUri(String svg) {
        return UrlKit.getDataUriBase64((String)"image/svg+xml", (String)Base64.encode((CharSequence)svg));
    }
}

